/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.container.OmsContainer;
import tech.powerjob.worker.container.OmsContainerFactory;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.extension.processor.ProcessorFactory;

public class JarContainerProcessorFactory
implements ProcessorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JarContainerProcessorFactory.class);
    private final WorkerRuntime workerRuntime;

    public JarContainerProcessorFactory(WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
    }

    @Override
    public Set<String> supportTypes() {
        return Sets.newHashSet((Object[])new String[]{ProcessorType.EXTERNAL.name()});
    }

    @Override
    public ProcessorBean build(ProcessorDefinition processorDefinition) {
        String processorInfo = processorDefinition.getProcessorInfo();
        String[] split = processorInfo.split("#");
        String containerName = split[0];
        String className = split[1];
        log.info("[ProcessorFactory] try to load processor({}) in container({})", (Object)className, (Object)containerName);
        OmsContainer omsContainer = OmsContainerFactory.fetchContainer(Long.valueOf(containerName), this.workerRuntime);
        if (omsContainer != null) {
            return new ProcessorBean().setProcessor(omsContainer.getProcessor(className)).setClassLoader(omsContainer.getContainerClassLoader()).setStable(false);
        }
        log.warn("[ProcessorFactory] load container failed. processor info : {}", (Object)processorInfo);
        return null;
    }
}

