/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor.impl;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.processor.impl.AbstractBuildInSpringProcessorFactory;

public class BuiltInSpringProcessorFactory
extends AbstractBuildInSpringProcessorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuiltInSpringProcessorFactory.class);

    public BuiltInSpringProcessorFactory(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public ProcessorBean build(ProcessorDefinition processorDefinition) {
        try {
            boolean canLoad = this.checkCanLoad();
            if (!canLoad) {
                log.info("[ProcessorFactory] can't find Spring env, this processor can't load by 'BuiltInSpringProcessorFactory'");
                return null;
            }
            String processorInfo = processorDefinition.getProcessorInfo();
            if (processorInfo.contains("#")) {
                return null;
            }
            BasicProcessor basicProcessor = (BasicProcessor)BuiltInSpringProcessorFactory.getBean(processorInfo, this.applicationContext);
            return new ProcessorBean().setProcessor(basicProcessor).setClassLoader(basicProcessor.getClass().getClassLoader());
        }
        catch (NoSuchBeanDefinitionException ignore) {
            log.warn("[ProcessorFactory] can't find the processor in SPRING");
        }
        catch (Throwable t) {
            log.warn("[ProcessorFactory] load by BuiltInSpringProcessorFactory failed. If you are using Spring, make sure this bean was managed by Spring", t);
        }
        return null;
    }
}

