/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.extension.processor.ProcessorFactory;

public class BuiltInDefaultProcessorFactory
implements ProcessorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuiltInDefaultProcessorFactory.class);

    @Override
    public Set<String> supportTypes() {
        return Sets.newHashSet((Object[])new String[]{ProcessorType.BUILT_IN.name()});
    }

    @Override
    public ProcessorBean build(ProcessorDefinition processorDefinition) {
        String className = processorDefinition.getProcessorInfo();
        try {
            Class<?> clz = Class.forName(className);
            BasicProcessor basicProcessor = (BasicProcessor)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new ProcessorBean().setProcessor(basicProcessor).setClassLoader(basicProcessor.getClass().getClassLoader());
        }
        catch (Exception e) {
            log.warn("[ProcessorFactory] load local Processor(className = {}) failed.", (Object)className, (Object)e);
            return null;
        }
    }
}

