/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor.impl;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import tech.powerjob.worker.annotation.PowerJobHandler;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.processor.impl.AbstractBuildInSpringProcessorFactory;
import tech.powerjob.worker.processor.impl.MethodBasicProcessor;

public class BuildInSpringMethodProcessorFactory
extends AbstractBuildInSpringProcessorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildInSpringMethodProcessorFactory.class);
    private static final List<String> jobHandlerRepository = new LinkedList<String>();
    private static final String DELIMITER = "#";

    public BuildInSpringMethodProcessorFactory(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public ProcessorBean build(ProcessorDefinition processorDefinition) {
        try {
            Method[] methods;
            boolean canLoad = this.checkCanLoad();
            if (!canLoad) {
                log.info("[ProcessorFactory] can't find Spring env, this processor can't load by 'BuildInSpringMethodProcessorFactory'");
                return null;
            }
            String processorInfo = processorDefinition.getProcessorInfo();
            if (!processorInfo.contains(DELIMITER)) {
                log.info("[ProcessorFactory] can't parse processorDefinition, this processor can't load by 'BuildInSpringMethodProcessorFactory'");
                return null;
            }
            String[] split = processorInfo.split(DELIMITER);
            String methodName = split[1];
            String className = split[0];
            Object bean = BuildInSpringMethodProcessorFactory.getBean(className, this.applicationContext);
            for (Method method : methods = bean.getClass().getDeclaredMethods()) {
                String name;
                PowerJobHandler powerJob = method.getAnnotation(PowerJobHandler.class);
                if (powerJob == null) {
                    powerJob = (PowerJobHandler)AnnotationUtils.findAnnotation((Method)method, PowerJobHandler.class);
                }
                if (powerJob == null || !(name = powerJob.name()).equals(methodName)) continue;
                if (name.trim().length() == 0) {
                    throw new RuntimeException("method-jobhandler name invalid, for[" + bean.getClass() + DELIMITER + method.getName() + "] .");
                }
                if (this.containsJobHandler(name)) {
                    throw new RuntimeException("jobhandler[" + name + "] naming conflicts.");
                }
                method.setAccessible(true);
                BuildInSpringMethodProcessorFactory.registerJobHandler(methodName);
                MethodBasicProcessor processor = new MethodBasicProcessor(bean, method);
                return new ProcessorBean().setProcessor(processor).setClassLoader(processor.getClass().getClassLoader());
            }
        }
        catch (NoSuchBeanDefinitionException ignore) {
            log.warn("[ProcessorFactory] can't find the processor in SPRING");
        }
        catch (Throwable t) {
            log.warn("[ProcessorFactory] load by BuiltInSpringProcessorFactory failed. If you are using Spring, make sure this bean was managed by Spring", t);
        }
        return null;
    }

    public static void registerJobHandler(String name) {
        jobHandlerRepository.add(name);
    }

    private boolean containsJobHandler(String name) {
        return jobHandlerRepository.contains(name);
    }
}

