/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.worker.extension.processor.ProcessorFactory;

public abstract class AbstractBuildInSpringProcessorFactory
implements ProcessorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBuildInSpringProcessorFactory.class);
    protected final ApplicationContext applicationContext;

    protected AbstractBuildInSpringProcessorFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Set<String> supportTypes() {
        return Sets.newHashSet((Object[])new String[]{ProcessorType.BUILT_IN.name()});
    }

    protected boolean checkCanLoad() {
        try {
            ApplicationContext.class.getClassLoader();
            return this.applicationContext != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected static <T> T getBean(String className, ApplicationContext ctx) throws Exception {
        try {
            Object bean = ctx.getBean(className);
            if (bean != null) {
                return (T)bean;
            }
        }
        catch (Exception bean) {
            // empty catch block
        }
        ClassLoader classLoader = ctx.getClassLoader();
        if (classLoader != null) {
            return (T)ctx.getBean(classLoader.loadClass(className));
        }
        String[] split = className.split("\\.");
        String beanName = split[split.length - 1];
        char[] cs = beanName.toCharArray();
        cs[0] = (char)(cs[0] + 32);
        String beanName0 = String.valueOf(cs);
        log.warn("[SpringUtils] can't get ClassLoader from context[{}], try to load by beanName:{}", (Object)ctx, (Object)beanName0);
        return (T)ctx.getBean(beanName0);
    }
}

