/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence.fs.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.worker.common.utils.PowerFileUtils;
import tech.powerjob.worker.persistence.fs.FsService;

public class LocalDiskFsService
implements FsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDiskFsService.class);
    private static final String WORKSPACE_PATH = PowerFileUtils.workspace() + "/fs/" + CommonUtils.genUUID() + "/";
    private static final String FILE_NAME_PATTERN = "%s.powerjob";
    private final File file;
    private final BufferedWriter bufferedWriter;
    private final BufferedReader bufferedReader;

    public LocalDiskFsService(String keyword) {
        String fileName = String.format(FILE_NAME_PATTERN, keyword);
        String filePath = WORKSPACE_PATH.concat(fileName);
        this.file = new File(filePath);
        FileUtils.createParentDirectories((File)this.file);
        FileWriter fileWriter = new FileWriter(this.file);
        this.bufferedWriter = new BufferedWriter(fileWriter);
        this.bufferedReader = new BufferedReader(new FileReader(this.file));
        log.info("[LocalDiskFsService] new LocalDiskFsService successfully, path: {}", (Object)filePath);
    }

    @Override
    public synchronized void writeLine(String content) throws IOException {
        this.bufferedWriter.write(content);
        this.bufferedWriter.newLine();
        this.bufferedWriter.flush();
    }

    @Override
    public synchronized String readLine() throws IOException {
        return this.bufferedReader.readLine();
    }

    @Override
    public void close() {
        CommonUtils.executeIgnoreException(() -> {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
            }
        });
        CommonUtils.executeIgnoreException(() -> {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
        });
        CommonUtils.executeIgnoreException(() -> {
            boolean delete = this.file.delete();
            log.info("[LocalDiskFsService] delete file[{}] result: {}", (Object)this.file, (Object)delete);
        });
    }
}

