/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence.fs.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.worker.persistence.TaskDO;
import tech.powerjob.worker.persistence.fs.ExternalTaskPersistenceService;
import tech.powerjob.worker.persistence.fs.FsService;
import tech.powerjob.worker.persistence.fs.impl.LocalDiskFsService;

public class ExternalTaskFileSystemPersistenceService
implements ExternalTaskPersistenceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalTaskFileSystemPersistenceService.class);
    private final Long instanceId;
    private final FsService pendingFsService;
    private final FsService resultFsService;
    private static final String PENDING_FILE_NAME = "%d-pending";
    private static final String RESULT_FILE_NAME = "%d-result";

    public ExternalTaskFileSystemPersistenceService(Long instanceId, boolean needResult) {
        this.instanceId = instanceId;
        this.pendingFsService = new LocalDiskFsService(String.format(PENDING_FILE_NAME, instanceId));
        this.resultFsService = needResult ? new LocalDiskFsService(String.format(RESULT_FILE_NAME, instanceId)) : new FsService(){

            @Override
            public void writeLine(String content) throws IOException {
            }

            @Override
            public String readLine() throws IOException {
                return null;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public boolean persistPendingTask(List<TaskDO> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return true;
        }
        try {
            String content = JsonUtils.toJSONString(tasks);
            this.pendingFsService.writeLine(content);
            return true;
        }
        catch (Exception e) {
            log.error("[ExternalTaskPersistenceService] [{}] persistPendingTask failed: {}", (Object)this.instanceId, tasks);
            return false;
        }
    }

    @Override
    public List<TaskDO> readPendingTask() {
        String pendingTaskStr = this.pendingFsService.readLine();
        return ExternalTaskFileSystemPersistenceService.str2TaskDoList(pendingTaskStr);
    }

    @Override
    public boolean persistFinishedTask(List<TaskDO> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return true;
        }
        tasks.forEach(t -> t.setTaskContent(null));
        try {
            String content = JsonUtils.toJSONString(tasks);
            this.resultFsService.writeLine(content);
            return true;
        }
        catch (Exception e) {
            log.error("[ExternalTaskPersistenceService] [{}] persistPendingTask failed: {}", (Object)this.instanceId, tasks);
            return false;
        }
    }

    @Override
    public List<TaskDO> readFinishedTask() {
        String finishedStr = this.resultFsService.readLine();
        return ExternalTaskFileSystemPersistenceService.str2TaskDoList(finishedStr);
    }

    private static List<TaskDO> str2TaskDoList(String finishedStr) throws Exception {
        if (StringUtils.isEmpty((CharSequence)finishedStr)) {
            return Collections.emptyList();
        }
        Object[] taskDOS = (TaskDO[])JsonUtils.parseObject((String)finishedStr, TaskDO[].class);
        if (taskDOS != null) {
            return Lists.newArrayList((Object[])taskDOS);
        }
        return Collections.emptyList();
    }

    @Override
    public void close() {
        CommonUtils.executeIgnoreException(() -> {
            if (this.pendingFsService != null) {
                this.pendingFsService.close();
            }
        });
        CommonUtils.executeIgnoreException(() -> {
            if (this.resultFsService != null) {
                this.resultFsService.close();
            }
        });
    }
}

