/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.h2.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.JavaUtils;
import tech.powerjob.worker.common.constants.StoreStrategy;
import tech.powerjob.worker.common.utils.PowerFileUtils;

public class ConnectionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private volatile DataSource dataSource;
    private final String H2_PATH = PowerFileUtils.workspace() + "/h2/" + CommonUtils.genUUID() + "/";
    private final String DISK_JDBC_URL = String.format("jdbc:h2:file:%spowerjob_worker_db;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false", this.H2_PATH);
    private final String MEMORY_JDBC_URL = String.format("jdbc:h2:mem:%spowerjob_worker_db;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false", this.H2_PATH);

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public synchronized void initDatasource(StoreStrategy strategy) {
        log.info("[PowerDatasource] H2 database version: {}", (Object)JavaUtils.determinePackageVersion(Driver.class));
        strategy = strategy == null ? StoreStrategy.DISK : strategy;
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(Driver.class.getName());
        config.setJdbcUrl(strategy == StoreStrategy.DISK ? this.DISK_JDBC_URL : this.MEMORY_JDBC_URL);
        config.setAutoCommit(true);
        config.setMinimumIdle(2);
        config.setMaximumPoolSize(32);
        this.dataSource = new HikariDataSource(config);
        log.info("[PowerDatasource] init h2 datasource successfully, use url: {}", (Object)config.getJdbcUrl());
        try {
            FileUtils.forceDeleteOnExit((File)new File(this.H2_PATH));
            log.info("[PowerDatasource] delete worker db file[{}] on JVM exit successfully", (Object)this.H2_PATH);
        }
        catch (Throwable t) {
            log.warn("[PowerDatasource] delete file on JVM exit failed: {}", (Object)this.H2_PATH, (Object)t);
        }
    }
}

