/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.SupplierPlus;
import tech.powerjob.worker.common.constants.StoreStrategy;
import tech.powerjob.worker.common.constants.TaskStatus;
import tech.powerjob.worker.core.processor.TaskResult;
import tech.powerjob.worker.persistence.TaskDO;
import tech.powerjob.worker.persistence.TaskPersistenceService;
import tech.powerjob.worker.persistence.db.ConnectionFactory;
import tech.powerjob.worker.persistence.db.SimpleTaskQuery;
import tech.powerjob.worker.persistence.db.TaskDAO;
import tech.powerjob.worker.persistence.db.TaskDAOImpl;

public class DbTaskPersistenceService
implements TaskPersistenceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbTaskPersistenceService.class);
    private final StoreStrategy strategy;
    private static final int RETRY_TIMES = 3;
    private static final long RETRY_INTERVAL_MS = 100L;
    private static final long SLOW_QUERY_RT_THRESHOLD = 200L;
    private TaskDAO taskDAO;

    public DbTaskPersistenceService(StoreStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void init() throws Exception {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.initDatasource(this.strategy);
        this.taskDAO = new TaskDAOImpl(connectionFactory);
        this.taskDAO.initTable();
    }

    @Override
    public boolean batchSave(List<TaskDO> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return true;
        }
        try {
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.batchSave(tasks), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] batchSave cost {}ms", (Object)((TaskDO)tasks.get(0)).getInstanceId(), cost));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] batchSave tasks({}) failed.", tasks, (Object)e);
            return false;
        }
    }

    @Override
    public boolean updateTask(Long instanceId, String taskId, TaskDO updateEntity) {
        try {
            updateEntity.setLastModifiedTime(System.currentTimeMillis());
            SimpleTaskQuery query = DbTaskPersistenceService.genKeyQuery(instanceId, taskId);
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleUpdate(query, updateEntity), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] updateTask(taskId={}) cost {}ms", new Object[]{instanceId, taskId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTask failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateTaskStatus(Long instanceId, String taskId, int status, long lastReportTime, String result) {
        try {
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.updateTaskStatus(instanceId, taskId, status, lastReportTime, result), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] updateTaskStatus(taskId={}) cost {}ms", new Object[]{instanceId, taskId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTaskStatus failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateLostTasks(Long instanceId, List<String> addressList, boolean retry) {
        TaskDO updateEntity = new TaskDO();
        updateEntity.setLastModifiedTime(System.currentTimeMillis());
        if (retry) {
            updateEntity.setAddress("N/A");
            updateEntity.setStatus(TaskStatus.WAITING_DISPATCH.getValue());
        } else {
            updateEntity.setStatus(TaskStatus.WORKER_PROCESS_FAILED.getValue());
            updateEntity.setResult("maybe worker down");
        }
        SimpleTaskQuery query = new SimpleTaskQuery();
        query.setInstanceId(instanceId);
        String queryConditionFormat = "address in %s and status not in (%d, %d)";
        String queryCondition = String.format(queryConditionFormat, CommonUtils.getInStringCondition(addressList), TaskStatus.WORKER_PROCESS_FAILED.getValue(), TaskStatus.WORKER_PROCESS_SUCCESS.getValue());
        query.setQueryCondition(queryCondition);
        log.debug("[TaskPersistenceService] updateLostTasks-QUERY-SQL: {}", (Object)query.getQueryCondition());
        try {
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleUpdate(query, updateEntity), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] updateLostTasks cost {}ms", (Object)instanceId, cost));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateLostTasks failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public Optional<TaskDO> getLastTask(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setSubInstanceId(subInstanceId);
            query.setTaskName("OMS_LAST_TASK");
            return (Optional)DbTaskPersistenceService.execute(() -> {
                List<TaskDO> taskDOS = this.taskDAO.simpleQuery(query);
                if (CollectionUtils.isEmpty(taskDOS)) {
                    return Optional.empty();
                }
                return Optional.of(taskDOS.get(0));
            }, cost -> log.warn("[TaskPersistenceService] [Slow] [{}.{}] getLastTask cost {}ms", new Object[]{instanceId, subInstanceId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] get last task for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public List<TaskDO> getAllUnFinishedTaskByAddress(Long instanceId, String address) {
        try {
            String condition = String.format("status not in (%d, %d)", TaskStatus.WORKER_PROCESS_SUCCESS.getValue(), TaskStatus.WORKER_PROCESS_FAILED.getValue());
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setAddress(address);
            query.setQueryCondition(condition);
            return (List)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleQuery(query), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] getAllUnFinishedTaskByAddress({}) cost {}ms", new Object[]{instanceId, address, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getAllTaskByAddress for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public List<TaskDO> getTaskByStatus(Long instanceId, TaskStatus status, int limit) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setStatus(status.getValue());
            query.setLimit(limit);
            return (List)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleQuery(query), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] getTaskByStatus({}) cost {}ms", new Object[]{instanceId, status, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskByStatus failed, params is instanceId={},status={}.", new Object[]{instanceId, status, e});
            return Lists.newArrayList();
        }
    }

    @Override
    public Map<TaskStatus, Long> getTaskStatusStatistics(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery query = new SimpleTaskQuery();
            query.setInstanceId(instanceId);
            query.setSubInstanceId(subInstanceId);
            query.setQueryContent("status, count(*) as num");
            query.setOtherCondition("GROUP BY status");
            return (Map)DbTaskPersistenceService.execute(() -> {
                List<Map<String, Object>> dbRES = this.taskDAO.simpleQueryPlus(query);
                HashMap result = Maps.newHashMap();
                dbRES.forEach(row -> {
                    int status = Integer.parseInt(String.valueOf(row.get("status")));
                    long num = Long.parseLong(String.valueOf(row.get("num")));
                    result.put(TaskStatus.of(status), num);
                });
                return result;
            }, cost -> log.warn("[TaskPersistenceService] [Slow] [{}.{}] getTaskStatusStatistics cost {}ms", new Object[]{instanceId, subInstanceId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskStatusStatistics for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Maps.newHashMap();
        }
    }

    @Override
    public List<TaskResult> getAllTaskResult(Long instanceId, Long subInstanceId) {
        try {
            return (List)DbTaskPersistenceService.execute(() -> this.taskDAO.getAllTaskResult(instanceId, subInstanceId), cost -> log.warn("[TaskPersistenceService] [Slow] [{}.{}] getAllTaskResult cost {}ms", new Object[]{instanceId, subInstanceId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskId2ResultMap for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Lists.newLinkedList();
        }
    }

    @Override
    public List<TaskDO> getTaskByQuery(Long instanceId, String customQuery) {
        SimpleTaskQuery simpleTaskQuery = new SimpleTaskQuery();
        simpleTaskQuery.setInstanceId(instanceId);
        simpleTaskQuery.setFullCustomQueryCondition(customQuery);
        simpleTaskQuery.setReadOnly(true);
        try {
            return (List)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleQuery(simpleTaskQuery), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] getTaskByQuery cost {}ms", (Object)instanceId, cost));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskByQuery for instance(id={}) failed.", (Object)instanceId, (Object)e);
            return Lists.newLinkedList();
        }
    }

    @Override
    public Optional<TaskDO> getTask(Long instanceId, String taskId) {
        try {
            SimpleTaskQuery query = DbTaskPersistenceService.genKeyQuery(instanceId, taskId);
            return (Optional)DbTaskPersistenceService.execute(() -> {
                List<TaskDO> res = this.taskDAO.simpleQuery(query);
                if (CollectionUtils.isEmpty(res)) {
                    return Optional.empty();
                }
                return Optional.of(res.get(0));
            }, cost -> log.warn("[TaskPersistenceService] [Slow] [{}] getTask(taskId={}) cost {}ms", new Object[]{instanceId, taskId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTask failed, instanceId={},taskId={}.", new Object[]{instanceId, taskId, e});
            return Optional.empty();
        }
    }

    @Override
    public boolean deleteAllTasks(Long instanceId) {
        try {
            SimpleTaskQuery condition = new SimpleTaskQuery();
            condition.setInstanceId(instanceId);
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleDelete(condition), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] deleteAllTasks cost {}ms", (Object)instanceId, cost));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteAllTasks failed, instanceId={}.", (Object)instanceId, (Object)e);
            return false;
        }
    }

    @Override
    public boolean deleteAllSubInstanceTasks(Long instanceId, Long subInstanceId) {
        try {
            SimpleTaskQuery condition = new SimpleTaskQuery();
            condition.setInstanceId(instanceId);
            condition.setSubInstanceId(subInstanceId);
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleDelete(condition), cost -> log.warn("[TaskPersistenceService] [Slow] [{}.{}] deleteAllSubInstanceTasks cost {}ms", new Object[]{instanceId, subInstanceId, cost}));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteAllTasks failed, instanceId={}.", (Object)instanceId, (Object)e);
            return false;
        }
    }

    @Override
    public boolean deleteTasksByTaskIds(Long instanceId, Collection<String> taskId) {
        try {
            SimpleTaskQuery condition = new SimpleTaskQuery();
            condition.setInstanceId(instanceId);
            condition.setTaskIds(taskId);
            return (Boolean)DbTaskPersistenceService.execute(() -> this.taskDAO.simpleDelete(condition), cost -> log.warn("[TaskPersistenceService] [Slow] [{}] deleteTasksByTaskIds cost {}ms", (Object)instanceId, cost));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteTasksByTaskIds failed, instanceId={}.", (Object)instanceId, (Object)e);
            return false;
        }
    }

    private static SimpleTaskQuery genKeyQuery(Long instanceId, String taskId) {
        SimpleTaskQuery condition = new SimpleTaskQuery();
        condition.setInstanceId(instanceId);
        condition.setTaskId(taskId);
        return condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(SupplierPlus<T> executor, Consumer<Long> slowQueryLogger) throws Exception {
        long s = System.currentTimeMillis();
        try {
            Object object = CommonUtils.executeWithRetry(executor, (int)3, (long)100L);
            return (T)object;
        }
        finally {
            long cost = System.currentTimeMillis() - s;
            if (cost > 200L) {
                slowQueryLogger.accept(cost);
            }
        }
    }
}

