/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.tracker.task;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.ExecuteType;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.model.JobAdvancedRuntimeConfig;
import tech.powerjob.common.request.ServerQueryInstanceStatusReq;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.TransportUtils;
import tech.powerjob.worker.pojo.model.InstanceInfo;

public abstract class TaskTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskTracker.class);
    protected final long createTime = System.currentTimeMillis();
    protected final long instanceId;
    protected final InstanceInfo instanceInfo;
    protected final ExecuteType executeType;
    protected final JobAdvancedRuntimeConfig advancedRuntimeConfig;
    protected final Map<String, String> appendedWfContext;
    protected final WorkerRuntime workerRuntime;
    protected final AtomicBoolean finished;
    protected int reportFailedCnt = 0;
    protected static final int MAX_REPORT_FAILED_THRESHOLD = 5;

    protected TaskTracker(ServerScheduleJobReq req, WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
        this.instanceId = req.getInstanceId();
        this.instanceInfo = new InstanceInfo();
        this.instanceInfo.setJobId(req.getJobId());
        this.instanceInfo.setInstanceId(req.getInstanceId());
        this.instanceInfo.setWfInstanceId(req.getWfInstanceId());
        this.instanceInfo.setExecuteType(req.getExecuteType());
        this.instanceInfo.setProcessorType(req.getProcessorType());
        this.instanceInfo.setProcessorInfo(req.getProcessorInfo());
        this.instanceInfo.setJobParams(req.getJobParams());
        this.instanceInfo.setInstanceParams(req.getInstanceParams());
        this.instanceInfo.setThreadConcurrency(req.getThreadConcurrency());
        this.instanceInfo.setTaskRetryNum(req.getTaskRetryNum());
        this.instanceInfo.setLogConfig(req.getLogConfig());
        this.instanceInfo.setInstanceTimeoutMS(req.getInstanceTimeoutMS());
        this.instanceInfo.setAdvancedRuntimeConfig(req.getAdvancedRuntimeConfig());
        this.instanceInfo.setMeta(req.getMeta());
        this.executeType = ExecuteType.valueOf((String)req.getExecuteType());
        this.advancedRuntimeConfig = Optional.ofNullable(req.getAdvancedRuntimeConfig()).map(x -> (JobAdvancedRuntimeConfig)JsonUtils.parseObjectIgnoreException((String)x, JobAdvancedRuntimeConfig.class)).orElse(new JobAdvancedRuntimeConfig());
        if (this.instanceInfo.getInstanceTimeoutMS() <= 0L) {
            this.instanceInfo.setInstanceTimeoutMS(Integer.MAX_VALUE);
        }
        this.appendedWfContext = req.getWfInstanceId() == null ? Collections.emptyMap() : Maps.newConcurrentMap();
        this.finished = new AtomicBoolean(false);
    }

    public abstract void destroy();

    public abstract void stopTask();

    public abstract InstanceDetail fetchRunningStatus(ServerQueryInstanceStatusReq var1);

    public static void reportCreateErrorToServer(ServerScheduleJobReq req, WorkerRuntime workerRuntime, Exception e) {
        log.warn("[TaskTracker-{}] create TaskTracker from request({}) failed.", new Object[]{req.getInstanceId(), req, e});
        TaskTrackerReportInstanceStatusReq response = new TaskTrackerReportInstanceStatusReq();
        response.setAppId(workerRuntime.getAppId());
        response.setJobId(req.getJobId());
        response.setInstanceId(req.getInstanceId());
        response.setWfInstanceId(req.getWfInstanceId());
        response.setInstanceStatus(InstanceStatus.FAILED.getV());
        response.setResult(String.format("init TaskTracker failed, reason: %s", e.toString()));
        response.setReportTime(System.currentTimeMillis());
        response.setStartTime(System.currentTimeMillis());
        response.setSourceAddress(workerRuntime.getWorkerAddress());
        TransportUtils.ttReportInstanceStatus(response, workerRuntime.getServerDiscoveryService().getCurrentServerAddress(), workerRuntime.getTransporter());
    }

    protected void reportFinalStatusThenDestroy(WorkerRuntime workerRuntime, TaskTrackerReportInstanceStatusReq reportInstanceStatusReq) {
        String currentServerAddress = workerRuntime.getServerDiscoveryService().getCurrentServerAddress();
        boolean serverAccepted = false;
        try {
            serverAccepted = TransportUtils.reliableTtReportInstanceStatus(reportInstanceStatusReq, currentServerAddress, workerRuntime.getTransporter());
        }
        catch (Exception e) {
            log.warn("[TaskTracker-{}] report finished status failed, req={}.", new Object[]{this.instanceId, reportInstanceStatusReq, e});
        }
        if (!serverAccepted) {
            if (++this.reportFailedCnt > 5) {
                log.error("[TaskTracker-{}] try to report finished status(detail={}) lots of times but all failed, it's time to give up, so the process result will be dropped", (Object)this.instanceId, (Object)reportInstanceStatusReq);
                this.destroy();
            }
            return;
        }
        log.info("[TaskTracker-{}] report finished status(detail={}) success", (Object)this.instanceId, (Object)reportInstanceStatusReq);
        this.destroy();
    }
}

