/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.processor;

import com.google.common.collect.Maps;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.serialize.JsonUtils;

public class WorkflowContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowContext.class);
    private final Long wfInstanceId;
    private final Map<String, String> data = Maps.newHashMap();
    private final Map<String, String> appendedContextData = Maps.newConcurrentMap();

    public WorkflowContext(Long wfInstanceId, String data) {
        this.wfInstanceId = wfInstanceId;
        if (wfInstanceId == null || StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        try {
            Map originMap = (Map)JsonUtils.parseObject((String)data, Map.class);
            originMap.forEach((k, v) -> this.data.put(String.valueOf(k), v == null ? null : String.valueOf(v)));
        }
        catch (Exception exception) {
            log.warn("[WorkflowContext-{}] parse workflow context failed, {}", (Object)wfInstanceId, (Object)exception.getMessage());
        }
    }

    public Map<String, String> fetchWorkflowContext() {
        return this.data;
    }

    public void appendData2WfContext(String key, Object value) {
        String finalValue;
        if (this.wfInstanceId == null) {
            return;
        }
        try {
            finalValue = JsonUtils.toJSONStringUnsafe((Object)value);
        }
        catch (Exception e) {
            log.warn("[WorkflowContext-{}] fail to append data to workflow context, key : {}", (Object)this.wfInstanceId, (Object)key);
            return;
        }
        this.appendedContextData.put(key, finalValue);
    }

    @Generated
    public Long getWfInstanceId() {
        return this.wfInstanceId;
    }

    @Generated
    public Map<String, String> getData() {
        return this.data;
    }

    @Generated
    public Map<String, String> getAppendedContextData() {
        return this.appendedContextData;
    }
}

