/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.ha;

import lombok.Generated;
import tech.powerjob.worker.pojo.request.ProcessorTrackerStatusReportReq;

public class ProcessorTrackerStatus {
    private static final int DISPATCH_THRESHOLD = 20;
    private static final int HEARTBEAT_TIMEOUT_MS = 60000;
    private String address;
    private long lastActiveTime;
    private long remainTaskNum;
    private boolean dispatched;
    private boolean connected;

    public void init(String address) {
        this.address = address;
        this.lastActiveTime = -1L;
        this.remainTaskNum = 0L;
        this.dispatched = false;
        this.connected = false;
    }

    public void update(ProcessorTrackerStatusReportReq req) {
        if (req.getTime() <= this.lastActiveTime) {
            return;
        }
        this.address = req.getAddress();
        this.lastActiveTime = req.getTime();
        this.remainTaskNum = req.getRemainTaskNum();
        this.dispatched = true;
        this.connected = true;
    }

    public boolean available() {
        if (!this.dispatched) {
            return true;
        }
        if (!this.connected) {
            return false;
        }
        if (this.isTimeout()) {
            return false;
        }
        return this.remainTaskNum < 20L;
    }

    public boolean isTimeout() {
        if (this.dispatched) {
            return System.currentTimeMillis() - this.lastActiveTime > 60000L;
        }
        return false;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    @Generated
    public long getRemainTaskNum() {
        return this.remainTaskNum;
    }

    @Generated
    public boolean isDispatched() {
        return this.dispatched;
    }

    @Generated
    public boolean isConnected() {
        return this.connected;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    @Generated
    public void setRemainTaskNum(long remainTaskNum) {
        this.remainTaskNum = remainTaskNum;
    }

    @Generated
    public void setDispatched(boolean dispatched) {
        this.dispatched = dispatched;
    }

    @Generated
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessorTrackerStatus)) {
            return false;
        }
        ProcessorTrackerStatus other = (ProcessorTrackerStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastActiveTime() != other.getLastActiveTime()) {
            return false;
        }
        if (this.getRemainTaskNum() != other.getRemainTaskNum()) {
            return false;
        }
        if (this.isDispatched() != other.isDispatched()) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessorTrackerStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastActiveTime = this.getLastActiveTime();
        result = result * 59 + (int)($lastActiveTime >>> 32 ^ $lastActiveTime);
        long $remainTaskNum = this.getRemainTaskNum();
        result = result * 59 + (int)($remainTaskNum >>> 32 ^ $remainTaskNum);
        result = result * 59 + (this.isDispatched() ? 79 : 97);
        result = result * 59 + (this.isConnected() ? 79 : 97);
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessorTrackerStatus(address=" + this.getAddress() + ", lastActiveTime=" + this.getLastActiveTime() + ", remainTaskNum=" + this.getRemainTaskNum() + ", dispatched=" + this.isDispatched() + ", connected=" + this.isConnected() + ")";
    }

    @Generated
    public ProcessorTrackerStatus() {
    }
}

