/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.common.utils;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.exception.PowerJobCheckedException;
import tech.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import tech.powerjob.common.request.WorkerHeartbeat;
import tech.powerjob.common.request.WorkerLogReportReq;
import tech.powerjob.common.request.WorkerNeedDeployContainerRequest;
import tech.powerjob.common.request.WorkerQueryExecutorClusterReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.remote.framework.base.Address;
import tech.powerjob.remote.framework.base.HandlerLocation;
import tech.powerjob.remote.framework.base.ServerType;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.remote.framework.transporter.Transporter;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.pojo.request.ProcessorMapTaskRequest;
import tech.powerjob.worker.pojo.request.ProcessorReportTaskStatusReq;
import tech.powerjob.worker.pojo.request.ProcessorTrackerStatusReportReq;
import tech.powerjob.worker.pojo.request.TaskTrackerStartTaskReq;
import tech.powerjob.worker.pojo.request.TaskTrackerStopInstanceReq;

public class TransportUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransportUtils.class);

    public static void ttReportInstanceStatus(TaskTrackerReportInstanceStatusReq req, String address, Transporter transporter) {
        URL url = TransportUtils.easyBuildUrl(ServerType.SERVER, "server", "reportInstanceStatus", address);
        transporter.tell(url, (PowerSerializable)req);
    }

    public static void ttStartPtTask(TaskTrackerStartTaskReq req, String address, Transporter transporter) {
        URL url = TransportUtils.easyBuildUrl(ServerType.WORKER, "processorTracker", "startTask", address);
        transporter.tell(url, (PowerSerializable)req);
    }

    public static void ttStopPtInstance(TaskTrackerStopInstanceReq req, String address, Transporter transporter) {
        URL url = TransportUtils.easyBuildUrl(ServerType.WORKER, "processorTracker", "stopInstance", address);
        transporter.tell(url, (PowerSerializable)req);
    }

    public static void ptReportTask(ProcessorReportTaskStatusReq req, String address, WorkerRuntime workerRuntime) {
        URL url = TransportUtils.easyBuildUrl(ServerType.WORKER, "taskTracker", "reportTaskStatus", address);
        workerRuntime.getTransporter().tell(url, (PowerSerializable)req);
    }

    public static void ptReportSelfStatus(ProcessorTrackerStatusReportReq req, String address, WorkerRuntime workerRuntime) {
        URL url = TransportUtils.easyBuildUrl(ServerType.WORKER, "taskTracker", "reportProcessorTrackerStatus", address);
        workerRuntime.getTransporter().tell(url, (PowerSerializable)req);
    }

    public static void reportLogs(WorkerLogReportReq req, String address, Transporter transporter) {
        URL url = TransportUtils.easyBuildUrl(ServerType.SERVER, "server", "reportLog", address);
        transporter.tell(url, (PowerSerializable)req);
    }

    public static void reportWorkerHeartbeat(WorkerHeartbeat req, String address, Transporter transporter) {
        URL url = TransportUtils.easyBuildUrl(ServerType.SERVER, "server", "workerHeartbeat", address);
        transporter.tell(url, (PowerSerializable)req);
    }

    public static boolean reliablePtReportTask(ProcessorReportTaskStatusReq req, String address, WorkerRuntime workerRuntime) {
        try {
            return TransportUtils.reliableAsk(ServerType.WORKER, "taskTracker", "reportTaskStatus", address, req, workerRuntime.getTransporter()).isSuccess();
        }
        catch (Exception e) {
            log.warn("[PowerJobTransport] reliablePtReportTask failed: {}", (Object)req, (Object)e);
            return false;
        }
    }

    public static boolean reliableMapTask(ProcessorMapTaskRequest req, String address, WorkerRuntime workerRuntime) throws PowerJobCheckedException {
        try {
            return TransportUtils.reliableAsk(ServerType.WORKER, "taskTracker", "mapTask", address, req, workerRuntime.getTransporter()).isSuccess();
        }
        catch (Throwable throwable) {
            throw new PowerJobCheckedException(throwable);
        }
    }

    public static boolean reliableTtReportInstanceStatus(TaskTrackerReportInstanceStatusReq req, String address, Transporter transporter) {
        return TransportUtils.reliableAsk(ServerType.SERVER, "server", "reportInstanceStatus", address, (PowerSerializable)req, transporter).isSuccess();
    }

    public static AskResponse reliableQueryJobCluster(WorkerQueryExecutorClusterReq req, String address, Transporter transporter) {
        return TransportUtils.reliableAsk(ServerType.SERVER, "server", "queryJobCluster", address, (PowerSerializable)req, transporter);
    }

    public static AskResponse reliableQueryContainerInfo(WorkerNeedDeployContainerRequest req, String address, Transporter transporter) {
        return TransportUtils.reliableAsk(ServerType.SERVER, "server", "queryContainer", address, (PowerSerializable)req, transporter);
    }

    private static AskResponse reliableAsk(ServerType t, String rootPath, String handlerPath, String address, PowerSerializable req, Transporter transporter) throws Exception {
        URL url = TransportUtils.easyBuildUrl(t, rootPath, handlerPath, address);
        CompletionStage completionStage = transporter.ask(url, req, AskResponse.class);
        return (AskResponse)completionStage.toCompletableFuture().get(5000L, TimeUnit.MILLISECONDS);
    }

    public static URL easyBuildUrl(ServerType serverType, String rootPath, String handlerPath, String address) {
        HandlerLocation handlerLocation = new HandlerLocation().setRootPath(rootPath).setMethodPath(handlerPath);
        return new URL().setServerType(serverType).setAddress(Address.fromIpv4((String)address)).setLocation(handlerLocation);
    }
}

