/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.background.discovery;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.ImpossibleException;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.WorkerAppInfo;
import tech.powerjob.common.request.ServerDiscoveryRequest;
import tech.powerjob.common.response.ObjectResultDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.HttpUtils;
import tech.powerjob.worker.background.discovery.ServerDiscoveryService;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.core.tracker.manager.HeavyTaskTrackerManager;
import tech.powerjob.worker.core.tracker.task.heavy.HeavyTaskTracker;

public class PowerJobServerDiscoveryService
implements ServerDiscoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerJobServerDiscoveryService.class);
    private final WorkerAppInfo appInfo = new WorkerAppInfo();
    private String currentServerAddress;
    private final Map<String, String> ip2Address = Maps.newHashMap();
    private static final String DISCOVERY_URL = "http://%s/server/acquire?%s";
    private static final String ASSERT_URL = "http://%s/server/assert?appName=%s";
    private static int FAILED_COUNT = 0;
    private static final int MAX_FAILED_COUNT = 3;
    private final PowerJobWorkerConfig config;

    public PowerJobServerDiscoveryService(PowerJobWorkerConfig config) {
        this.config = config;
    }

    @Override
    public WorkerAppInfo assertApp() {
        try {
            return this.assertApp0();
        }
        catch (Exception e) {
            if (this.config.isAllowLazyConnectServer()) {
                log.warn("[PowerJobWorker] worker is not currently connected to the server, and because allowLazyConnectServer is configured to true it won't block the startup, but you have to be aware that this is dangerous in production environments!");
                return this.appInfo;
            }
            ExceptionUtils.rethrow((Throwable)e);
            throw new ImpossibleException();
        }
    }

    private WorkerAppInfo assertApp0() {
        String appName = this.config.getAppName();
        Objects.requireNonNull(appName, "appName can't be empty!");
        for (String server : this.config.getServerAddress()) {
            String realUrl = String.format(ASSERT_URL, server, appName);
            try {
                String resultDTOStr = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)realUrl));
                ObjectResultDTO resultDTO = (ObjectResultDTO)JsonUtils.parseObject((String)resultDTOStr, ObjectResultDTO.class);
                if (resultDTO.isSuccess()) {
                    Object resultDataContent = resultDTO.getData();
                    log.info("[PowerJobWorker] assert appName({}) succeed, result from server is: {}.", (Object)appName, resultDataContent);
                    if (StringUtils.isNumeric((CharSequence)resultDataContent.toString())) {
                        Long appId = Long.valueOf(resultDataContent.toString());
                        this.appInfo.setAppId(appId);
                        return this.appInfo;
                    }
                    WorkerAppInfo serverAppInfo = (WorkerAppInfo)JsonUtils.parseObject((String)JsonUtils.toJSONString((Object)resultDataContent), WorkerAppInfo.class);
                    this.appInfo.setAppId(serverAppInfo.getAppId());
                    return this.appInfo;
                }
                log.error("[PowerJobWorker] assert appName failed, this appName is invalid, please register the appName {} first.", (Object)appName);
                throw new PowerJobException(resultDTO.getMessage());
            }
            catch (PowerJobException oe) {
                throw oe;
            }
            catch (Exception ignore) {
                log.warn("[PowerJobWorker] assert appName by url({}) failed, please check the server address.", (Object)realUrl);
            }
        }
        log.error("[PowerJobWorker] no available server in {}.", this.config.getServerAddress());
        throw new PowerJobException("no server available!");
    }

    @Override
    public String getCurrentServerAddress() {
        return this.currentServerAddress;
    }

    @Override
    public void timingCheck(ScheduledExecutorService timingPool) {
        this.currentServerAddress = this.discovery();
        if (StringUtils.isEmpty((CharSequence)this.currentServerAddress) && !this.config.isAllowLazyConnectServer()) {
            throw new PowerJobException("can't find any available server, this worker has been quarantined.");
        }
        timingPool.scheduleAtFixedRate(() -> {
            try {
                this.currentServerAddress = this.discovery();
            }
            catch (Exception e) {
                log.error("[PowerDiscovery] fail to discovery server!", (Throwable)e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private String discovery() {
        Object ip;
        String firstServerAddress;
        if (this.appInfo.getAppId() == null || this.appInfo.getAppId() < 0L) {
            try {
                this.assertApp0();
            }
            catch (Exception e) {
                log.warn("[PowerDiscovery] assertAppName in discovery stage failed, msg: {}", (Object)e.getMessage());
                return null;
            }
        }
        if (this.ip2Address.isEmpty()) {
            this.config.getServerAddress().forEach(x -> this.ip2Address.put(x.split(":")[0], (String)x));
        }
        String result = null;
        String currentServer = this.currentServerAddress;
        if (!StringUtils.isEmpty((CharSequence)currentServer) && (firstServerAddress = this.ip2Address.get(ip = currentServer.split(":")[0])) != null) {
            result = this.acquire(firstServerAddress);
        }
        for (String httpServerAddress : this.config.getServerAddress()) {
            if (!StringUtils.isEmpty(result)) break;
            result = this.acquire(httpServerAddress);
        }
        if (StringUtils.isEmpty(result)) {
            log.warn("[PowerDiscovery] can't find any available server, this worker has been quarantined.");
            if (FAILED_COUNT++ > 3) {
                log.warn("[PowerDiscovery] can't find any available server for 3 consecutive times, It's time to kill all frequent job in this worker.");
                List<Long> frequentInstanceIds = HeavyTaskTrackerManager.getAllFrequentTaskTrackerKeys();
                if (!CollectionUtils.isEmpty(frequentInstanceIds)) {
                    frequentInstanceIds.forEach(instanceId -> {
                        HeavyTaskTracker taskTracker = HeavyTaskTrackerManager.removeTaskTracker(instanceId);
                        taskTracker.destroy();
                        log.warn("[PowerDiscovery] kill frequent instance(instanceId={}) due to can't find any available server.", instanceId);
                    });
                }
                FAILED_COUNT = 0;
            }
            return null;
        }
        FAILED_COUNT = 0;
        log.debug("[PowerDiscovery] current server is {}.", result);
        return result;
    }

    private String acquire(String httpServerAddress) {
        String result = null;
        String url = this.buildServerDiscoveryUrl(httpServerAddress);
        try {
            result = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty(result)) {
            try {
                ObjectResultDTO resultDTO = (ObjectResultDTO)JsonUtils.parseObject((String)result, ObjectResultDTO.class);
                if (resultDTO.isSuccess()) {
                    return resultDTO.getData().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String buildServerDiscoveryUrl(String address) {
        ServerDiscoveryRequest serverDiscoveryRequest = new ServerDiscoveryRequest().setAppId(this.appInfo.getAppId()).setCurrentServer(this.currentServerAddress).setProtocol(this.config.getProtocol().name().toUpperCase());
        String query = Joiner.on((String)"&").withKeyValueSeparator("=").join(serverDiscoveryRequest.toMap());
        return String.format(DISCOVERY_URL, address, query);
    }
}

