/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.actors;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.request.ServerDeployContainerRequest;
import tech.powerjob.common.request.ServerDestroyContainerRequest;
import tech.powerjob.common.request.ServerQueryInstanceStatusReq;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.ServerStopInstanceReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.remote.framework.actor.Handler;
import tech.powerjob.worker.actors.TaskTrackerActor;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.container.OmsContainerFactory;

@Actor(path="worker")
public class WorkerActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerActor.class);
    private final WorkerRuntime workerRuntime;
    private final TaskTrackerActor taskTrackerActor;

    public WorkerActor(WorkerRuntime workerRuntime, TaskTrackerActor taskTrackerActor) {
        this.workerRuntime = workerRuntime;
        this.taskTrackerActor = taskTrackerActor;
    }

    @Handler(path="deployContainer")
    public void onReceiveServerDeployContainerRequest(ServerDeployContainerRequest request) {
        OmsContainerFactory.deployContainer(request);
    }

    @Handler(path="destroyContainer")
    public void onReceiveServerDestroyContainerRequest(ServerDestroyContainerRequest request) {
        OmsContainerFactory.destroyContainer(request.getContainerId());
    }

    @Handler(path="runJob")
    public void onReceiveServerScheduleJobReq(ServerScheduleJobReq req) {
        this.taskTrackerActor.onReceiveServerScheduleJobReq(req);
    }

    @Handler(path="stopInstance")
    public void onReceiveServerStopInstanceReq(ServerStopInstanceReq req) {
        this.taskTrackerActor.onReceiveServerStopInstanceReq(req);
    }

    @Handler(path="queryInstanceStatus")
    public AskResponse onReceiveServerQueryInstanceStatusReq(ServerQueryInstanceStatusReq req) {
        return this.taskTrackerActor.onReceiveServerQueryInstanceStatusReq(req);
    }
}

