/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.actors;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.remote.framework.actor.Handler;
import tech.powerjob.remote.framework.actor.ProcessType;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.core.tracker.manager.ProcessorTrackerManager;
import tech.powerjob.worker.core.tracker.processor.ProcessorTracker;
import tech.powerjob.worker.persistence.TaskDO;
import tech.powerjob.worker.pojo.request.TaskTrackerStartTaskReq;
import tech.powerjob.worker.pojo.request.TaskTrackerStopInstanceReq;

@Actor(path="processorTracker")
public class ProcessorTrackerActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessorTrackerActor.class);
    private final WorkerRuntime workerRuntime;

    public ProcessorTrackerActor(WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
    }

    @Handler(path="startTask", processType=ProcessType.NO_BLOCKING)
    public void onReceiveTaskTrackerStartTaskReq(TaskTrackerStartTaskReq req) {
        Long instanceId = req.getInstanceInfo().getInstanceId();
        ProcessorTracker processorTracker = ProcessorTrackerManager.getProcessorTracker(instanceId, req.getTaskTrackerAddress(), () -> new ProcessorTracker(req, this.workerRuntime));
        TaskDO task = new TaskDO();
        task.setTaskId(req.getTaskId());
        task.setTaskName(req.getTaskName());
        task.setTaskContent(req.getTaskContent());
        task.setFailedCnt(req.getTaskCurrentRetryNums());
        task.setSubInstanceId(req.getSubInstanceId());
        processorTracker.submitTask(task);
    }

    @Handler(path="stopInstance")
    public void onReceiveTaskTrackerStopInstanceReq(TaskTrackerStopInstanceReq req) {
        Long instanceId = req.getInstanceId();
        List<ProcessorTracker> removedPts = ProcessorTrackerManager.removeProcessorTracker(instanceId);
        if (!CollectionUtils.isEmpty(removedPts)) {
            removedPts.forEach(ProcessorTracker::destroy);
        }
    }
}

