/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.model.WorkerAppInfo;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.common.utils.PropertyUtils;
import tech.powerjob.remote.framework.base.Address;
import tech.powerjob.remote.framework.base.ServerType;
import tech.powerjob.remote.framework.engine.EngineConfig;
import tech.powerjob.remote.framework.engine.EngineOutput;
import tech.powerjob.remote.framework.engine.RemoteEngine;
import tech.powerjob.remote.framework.engine.impl.PowerJobRemoteEngine;
import tech.powerjob.worker.actors.ProcessorTrackerActor;
import tech.powerjob.worker.actors.TaskTrackerActor;
import tech.powerjob.worker.actors.WorkerActor;
import tech.powerjob.worker.background.OmsLogHandler;
import tech.powerjob.worker.background.discovery.PowerJobServerDiscoveryService;
import tech.powerjob.worker.background.heartbeat.DefaultSystemMetricsCollector;
import tech.powerjob.worker.background.heartbeat.WorkerHealthReporter;
import tech.powerjob.worker.common.PowerBannerPrinter;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.WorkerNetUtils;
import tech.powerjob.worker.core.executor.ExecutorManager;
import tech.powerjob.worker.persistence.DbTaskPersistenceService;
import tech.powerjob.worker.processor.PowerJobProcessorLoader;
import tech.powerjob.worker.processor.ProcessorLoader;
import tech.powerjob.worker.processor.impl.BuiltInDefaultProcessorFactory;
import tech.powerjob.worker.processor.impl.JarContainerProcessorFactory;

public class PowerJobWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerJobWorker.class);
    private final RemoteEngine remoteEngine;
    protected final WorkerRuntime workerRuntime;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public PowerJobWorker(PowerJobWorkerConfig config) {
        this.workerRuntime = new WorkerRuntime();
        this.remoteEngine = new PowerJobRemoteEngine();
        this.workerRuntime.setWorkerConfig(this.reConfig(config));
    }

    public void init() throws Exception {
        if (!this.initialized.compareAndSet(false, true)) {
            log.warn("[PowerJobWorker] please do not repeat the initialization");
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("[PowerJobWorker] start to initialize PowerJobWorker...");
        PowerJobWorkerConfig config = this.workerRuntime.getWorkerConfig();
        CommonUtils.requireNonNull((Object)config, (String)"can't find PowerJobWorkerConfig, please set PowerJobWorkerConfig first");
        PowerJobServerDiscoveryService serverDiscoveryService = new PowerJobServerDiscoveryService(config);
        this.workerRuntime.setServerDiscoveryService(serverDiscoveryService);
        try {
            PowerBannerPrinter.print();
            int localBindPort = config.getPort();
            String localBindIp = WorkerNetUtils.parseLocalBindIp(localBindPort, config.getServerAddress());
            WorkerAppInfo appInfo = serverDiscoveryService.assertApp();
            this.workerRuntime.setAppInfo(appInfo);
            String externalIp = PropertyUtils.readProperty((String)"powerjob.network.external.address", null);
            String externalPort = PropertyUtils.readProperty((String)"powerjob.network.external.port", (String)String.valueOf(localBindPort));
            log.info("[PowerJobWorker] [ADDRESS_INFO] localBindIp: {}, localBindPort: {}; externalIp: {}, externalPort: {}", new Object[]{localBindIp, localBindPort, externalIp, externalPort});
            this.workerRuntime.setWorkerAddress(Address.toFullAddress((String)Optional.ofNullable(externalIp).orElse(localBindIp), (int)Integer.parseInt(externalPort)));
            ExecutorManager executorManager = new ExecutorManager(this.workerRuntime.getWorkerConfig());
            this.workerRuntime.setExecutorManager(executorManager);
            ProcessorLoader processorLoader = this.buildProcessorLoader(this.workerRuntime);
            this.workerRuntime.setProcessorLoader(processorLoader);
            TaskTrackerActor taskTrackerActor = new TaskTrackerActor(this.workerRuntime);
            ProcessorTrackerActor processorTrackerActor = new ProcessorTrackerActor(this.workerRuntime);
            WorkerActor workerActor = new WorkerActor(this.workerRuntime, taskTrackerActor);
            EngineConfig engineConfig = new EngineConfig().setType(config.getProtocol().name()).setServerType(ServerType.WORKER).setBindAddress(new Address().setHost(localBindIp).setPort(localBindPort)).setActorList((List)Lists.newArrayList((Object[])new Object[]{taskTrackerActor, processorTrackerActor, workerActor}));
            if (StringUtils.isNotEmpty((CharSequence)externalIp)) {
                Address externalAddress = new Address().setHost(externalIp).setPort(Integer.parseInt(externalPort));
                engineConfig.setExternalAddress(externalAddress);
                log.info("[PowerJobWorker] [ADDRESS_INFO] exist externalIp, add external address to engine config: {}", (Object)externalAddress);
            }
            EngineOutput engineOutput = this.remoteEngine.start(engineConfig);
            this.workerRuntime.setTransporter(engineOutput.getTransporter());
            serverDiscoveryService.timingCheck(this.workerRuntime.getExecutorManager().getCoreExecutor());
            log.info("[PowerJobWorker] PowerJobRemoteEngine initialized successfully.");
            OmsLogHandler omsLogHandler = new OmsLogHandler(this.workerRuntime.getWorkerAddress(), this.workerRuntime.getTransporter(), serverDiscoveryService);
            this.workerRuntime.setOmsLogHandler(omsLogHandler);
            DbTaskPersistenceService taskPersistenceService = new DbTaskPersistenceService(this.workerRuntime.getWorkerConfig().getStoreStrategy());
            taskPersistenceService.init();
            this.workerRuntime.setTaskPersistenceService(taskPersistenceService);
            log.info("[PowerJobWorker] local storage initialized successfully.");
            this.workerRuntime.getExecutorManager().getCoreExecutor().scheduleAtFixedRate((Runnable)((Object)new WorkerHealthReporter(this.workerRuntime)), 0L, config.getHealthReportInterval().intValue(), TimeUnit.SECONDS);
            this.workerRuntime.getExecutorManager().getCoreExecutor().scheduleWithFixedDelay(omsLogHandler.logSubmitter, 0L, 5L, TimeUnit.SECONDS);
            log.info("[PowerJobWorker] PowerJobWorker initialized successfully, using time: {}, congratulations!", (Object)stopwatch);
        }
        catch (Exception e) {
            log.error("[PowerJobWorker] initialize PowerJobWorker failed, using {}.", (Object)stopwatch, (Object)e);
            throw e;
        }
    }

    private PowerJobWorkerConfig reConfig(PowerJobWorkerConfig config) {
        CommonUtils.requireNonNull(config.getServerAddress(), (String)"ServerAddress can't be null or empty!");
        Collections.shuffle(config.getServerAddress());
        if (config.getPort() < 0) {
            config.setPort(NetUtils.getRandomPort());
        }
        if (config.getSystemMetricsCollector() == null) {
            config.setSystemMetricsCollector(new DefaultSystemMetricsCollector());
        }
        return config;
    }

    private ProcessorLoader buildProcessorLoader(WorkerRuntime runtime) {
        List customPF = Optional.ofNullable(runtime.getWorkerConfig().getProcessorFactoryList()).orElse(Collections.emptyList());
        ArrayList finalPF = Lists.newArrayList(customPF);
        finalPF.add(new BuiltInDefaultProcessorFactory());
        finalPF.add(new JarContainerProcessorFactory(runtime));
        return new PowerJobProcessorLoader(finalPF);
    }

    public void destroy() throws Exception {
        this.workerRuntime.getExecutorManager().shutdown();
        this.remoteEngine.close();
    }
}

