/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.common.utils;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.HttpUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.common.utils.net.PingPongSocketServer;

public class WorkerNetUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkerNetUtils.class);
    private static final String SERVER_CONNECTIVITY_CHECK_URL_PATTERN = "http://%s/server/checkConnectivity?targetIp=%s&targetPort=%d";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseLocalBindIp(int port, List<String> serverAddress) {
        PingPongSocketServer pingPongServer = null;
        try {
            pingPongServer = new PingPongSocketServer();
            pingPongServer.initialize(port);
            log.info("[WorkerNetUtils] initialize PingPongSocketServer successfully~");
            String string = NetUtils.getLocalHostWithNetworkInterfaceChecker((networkInterface, inetAddress) -> {
                if (inetAddress == null) {
                    log.info("[WorkerNetUtils] [networkInterface:{}] skip due to inetAddress is null!", (Object)networkInterface);
                    return false;
                }
                String workerIp = inetAddress.getHostAddress();
                for (String address : serverAddress) {
                    String url = String.format(SERVER_CONNECTIVITY_CHECK_URL_PATTERN, address, workerIp, port);
                    try {
                        String resp = HttpUtils.get((String)url);
                        log.info("[WorkerNetUtils] [networkInterface:{},inetAddress:{}] check connectivity by url[{}], response: {}", new Object[]{networkInterface, inetAddress, url, resp});
                        if (!StringUtils.isNotEmpty((CharSequence)resp)) continue;
                        ResultDTO resultDTO = (ResultDTO)JsonUtils.parseObject((String)resp, ResultDTO.class);
                        boolean ret = Boolean.TRUE.toString().equalsIgnoreCase(String.valueOf(resultDTO.getData()));
                        if (!ret) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                }
                return false;
            });
            return string;
        }
        catch (Exception e) {
            log.warn("[WorkerNetUtils] PingPongSocketServer failed to start, which may result in an incorrectly bound IP, please pay attention to the initialize log.", (Throwable)e);
        }
        finally {
            if (pingPongServer != null) {
                try {
                    pingPongServer.close();
                    log.info("[WorkerNetUtils] close PingPongSocketServer successfully~");
                }
                catch (Exception e) {
                    log.warn("[WorkerNetUtils] close PingPongSocketServer failed!", (Throwable)e);
                }
            }
        }
        return NetUtils.getLocalHostWithNetworkInterfaceChecker(null);
    }
}

