/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.HttpUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.common.utils.PropertyUtils;
import tech.powerjob.remote.framework.base.Address;
import tech.powerjob.remote.framework.base.ServerType;
import tech.powerjob.remote.framework.engine.EngineConfig;
import tech.powerjob.remote.framework.engine.EngineOutput;
import tech.powerjob.remote.framework.engine.RemoteEngine;
import tech.powerjob.remote.framework.engine.impl.PowerJobRemoteEngine;
import tech.powerjob.worker.actors.ProcessorTrackerActor;
import tech.powerjob.worker.actors.TaskTrackerActor;
import tech.powerjob.worker.actors.WorkerActor;
import tech.powerjob.worker.background.OmsLogHandler;
import tech.powerjob.worker.background.ServerDiscoveryService;
import tech.powerjob.worker.background.WorkerHealthReporter;
import tech.powerjob.worker.common.PowerBannerPrinter;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.core.executor.ExecutorManager;
import tech.powerjob.worker.persistence.TaskPersistenceService;
import tech.powerjob.worker.processor.PowerJobProcessorLoader;
import tech.powerjob.worker.processor.ProcessorLoader;
import tech.powerjob.worker.processor.impl.BuiltInDefaultProcessorFactory;
import tech.powerjob.worker.processor.impl.JarContainerProcessorFactory;

public class PowerJobWorker {
    private static final Logger log = LoggerFactory.getLogger(PowerJobWorker.class);
    private final RemoteEngine remoteEngine;
    protected final WorkerRuntime workerRuntime;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public PowerJobWorker(PowerJobWorkerConfig config) {
        this.workerRuntime = new WorkerRuntime();
        this.remoteEngine = new PowerJobRemoteEngine();
        this.workerRuntime.setWorkerConfig(config);
    }

    public void init() throws Exception {
        if (!this.initialized.compareAndSet(false, true)) {
            log.warn("[PowerJobWorker] please do not repeat the initialization");
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("[PowerJobWorker] start to initialize PowerJobWorker...");
        PowerJobWorkerConfig config = this.workerRuntime.getWorkerConfig();
        CommonUtils.requireNonNull((Object)config, (String)"can't find PowerJobWorkerConfig, please set PowerJobWorkerConfig first");
        try {
            PowerBannerPrinter.print();
            if (!config.isEnableTestMode()) {
                this.assertAppName();
            } else {
                log.warn("[PowerJobWorker] using TestMode now, it's dangerous if this is production env.");
            }
            String localBindIp = NetUtils.getLocalHost();
            int localBindPort = config.getPort();
            String externalIp = PropertyUtils.readProperty((String)"powerjob.network.external.address", (String)localBindIp);
            String externalPort = PropertyUtils.readProperty((String)"powerjob.network.external.port", (String)String.valueOf(localBindPort));
            log.info("[PowerJobWorker] [ADDRESS_INFO] localBindIp: {}, localBindPort: {}; externalIp: {}, externalPort: {}", new Object[]{localBindIp, localBindPort, externalIp, externalPort});
            this.workerRuntime.setWorkerAddress(Address.toFullAddress((String)externalIp, (int)Integer.parseInt(externalPort)));
            ExecutorManager executorManager = new ExecutorManager(this.workerRuntime.getWorkerConfig());
            this.workerRuntime.setExecutorManager(executorManager);
            ProcessorLoader processorLoader = this.buildProcessorLoader(this.workerRuntime);
            this.workerRuntime.setProcessorLoader(processorLoader);
            TaskTrackerActor taskTrackerActor = new TaskTrackerActor(this.workerRuntime);
            ProcessorTrackerActor processorTrackerActor = new ProcessorTrackerActor(this.workerRuntime);
            WorkerActor workerActor = new WorkerActor(this.workerRuntime, taskTrackerActor);
            EngineConfig engineConfig = new EngineConfig().setType(config.getProtocol().name()).setServerType(ServerType.WORKER).setBindAddress(new Address().setHost(localBindIp).setPort(localBindPort)).setActorList((List)Lists.newArrayList((Object[])new Object[]{taskTrackerActor, processorTrackerActor, workerActor}));
            EngineOutput engineOutput = this.remoteEngine.start(engineConfig);
            this.workerRuntime.setTransporter(engineOutput.getTransporter());
            ServerDiscoveryService serverDiscoveryService = new ServerDiscoveryService(this.workerRuntime.getAppId(), this.workerRuntime.getWorkerConfig());
            serverDiscoveryService.start(this.workerRuntime.getExecutorManager().getCoreExecutor());
            this.workerRuntime.setServerDiscoveryService(serverDiscoveryService);
            log.info("[PowerJobWorker] PowerJobRemoteEngine initialized successfully.");
            OmsLogHandler omsLogHandler = new OmsLogHandler(this.workerRuntime.getWorkerAddress(), this.workerRuntime.getTransporter(), serverDiscoveryService);
            this.workerRuntime.setOmsLogHandler(omsLogHandler);
            TaskPersistenceService taskPersistenceService = new TaskPersistenceService(this.workerRuntime.getWorkerConfig().getStoreStrategy());
            taskPersistenceService.init();
            this.workerRuntime.setTaskPersistenceService(taskPersistenceService);
            log.info("[PowerJobWorker] local storage initialized successfully.");
            this.workerRuntime.getExecutorManager().getCoreExecutor().scheduleAtFixedRate(new WorkerHealthReporter(this.workerRuntime), 0L, config.getHealthReportInterval().intValue(), TimeUnit.SECONDS);
            this.workerRuntime.getExecutorManager().getCoreExecutor().scheduleWithFixedDelay(omsLogHandler.logSubmitter, 0L, 5L, TimeUnit.SECONDS);
            log.info("[PowerJobWorker] PowerJobWorker initialized successfully, using time: {}, congratulations!", (Object)stopwatch);
        }
        catch (Exception e) {
            log.error("[PowerJobWorker] initialize PowerJobWorker failed, using {}.", (Object)stopwatch, (Object)e);
            throw e;
        }
    }

    private void assertAppName() {
        PowerJobWorkerConfig config = this.workerRuntime.getWorkerConfig();
        String appName = config.getAppName();
        Objects.requireNonNull(appName, "appName can't be empty!");
        String url = "http://%s/server/assert?appName=%s";
        for (String server : config.getServerAddress()) {
            String realUrl = String.format(url, server, appName);
            try {
                String resultDTOStr = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)realUrl));
                ResultDTO resultDTO = (ResultDTO)JsonUtils.parseObject((String)resultDTOStr, ResultDTO.class);
                if (resultDTO.isSuccess()) {
                    Long appId = Long.valueOf(resultDTO.getData().toString());
                    log.info("[PowerJobWorker] assert appName({}) succeed, the appId for this application is {}.", (Object)appName, (Object)appId);
                    this.workerRuntime.setAppId(appId);
                    return;
                }
                log.error("[PowerJobWorker] assert appName failed, this appName is invalid, please register the appName {} first.", (Object)appName);
                throw new PowerJobException(resultDTO.getMessage());
            }
            catch (PowerJobException oe) {
                throw oe;
            }
            catch (Exception ignore) {
                log.warn("[PowerJobWorker] assert appName by url({}) failed, please check the server address.", (Object)realUrl);
            }
        }
        log.error("[PowerJobWorker] no available server in {}.", config.getServerAddress());
        throw new PowerJobException("no server available!");
    }

    private ProcessorLoader buildProcessorLoader(WorkerRuntime runtime) {
        List customPF = Optional.ofNullable(runtime.getWorkerConfig().getProcessorFactoryList()).orElse(Collections.emptyList());
        ArrayList finalPF = Lists.newArrayList(customPF);
        finalPF.add(new BuiltInDefaultProcessorFactory());
        finalPF.add(new JarContainerProcessorFactory(runtime));
        return new PowerJobProcessorLoader(finalPF);
    }

    public void destroy() throws Exception {
        this.workerRuntime.getExecutorManager().shutdown();
        this.remoteEngine.close();
    }
}

