/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.extension.processor.ProcessorFactory;

public class BuiltInSpringProcessorFactory
implements ProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(BuiltInSpringProcessorFactory.class);
    private final ApplicationContext applicationContext;

    public BuiltInSpringProcessorFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Set<String> supportTypes() {
        return Sets.newHashSet((Object[])new String[]{ProcessorType.BUILT_IN.name()});
    }

    @Override
    public ProcessorBean build(ProcessorDefinition processorDefinition) {
        try {
            boolean canLoad = this.checkCanLoad();
            if (!canLoad) {
                log.info("[ProcessorFactory] can't find Spring env, this processor can't load by 'BuiltInSpringProcessorFactory'");
                return null;
            }
            BasicProcessor basicProcessor = (BasicProcessor)BuiltInSpringProcessorFactory.getBean(processorDefinition.getProcessorInfo(), this.applicationContext);
            return new ProcessorBean().setProcessor(basicProcessor).setClassLoader(basicProcessor.getClass().getClassLoader());
        }
        catch (Throwable t) {
            log.warn("[ProcessorFactory] load by BuiltInSpringProcessorFactory failed. If you are using Spring, make sure this bean was managed by Spring", t);
            return null;
        }
    }

    private boolean checkCanLoad() {
        try {
            ApplicationContext.class.getClassLoader();
            return this.applicationContext != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static <T> T getBean(String className, ApplicationContext ctx) throws Exception {
        ClassLoader classLoader = ctx.getClassLoader();
        if (classLoader != null) {
            return (T)ctx.getBean(classLoader.loadClass(className));
        }
        String[] split = className.split("\\.");
        String beanName = split[split.length - 1];
        char[] cs = beanName.toCharArray();
        cs[0] = (char)(cs[0] + 32);
        String beanName0 = String.valueOf(cs);
        log.warn("[SpringUtils] can't get ClassLoader from context[{}], try to load by beanName:{}", (Object)ctx, (Object)beanName0);
        return (T)ctx.getBean(beanName0);
    }
}

