/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import tech.powerjob.worker.PowerJobWorker;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.processor.impl.BuiltInSpringProcessorFactory;

public class PowerJobSpringWorker
extends PowerJobWorker
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    public PowerJobSpringWorker(PowerJobWorkerConfig config) {
        super(config);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        BuiltInSpringProcessorFactory springProcessorFactory = new BuiltInSpringProcessorFactory(applicationContext);
        PowerJobWorkerConfig workerConfig = this.workerRuntime.getWorkerConfig();
        ArrayList processorFactories = Lists.newArrayList((Iterable)Optional.ofNullable(workerConfig.getProcessorFactoryList()).orElse(Collections.emptyList()));
        processorFactories.add(springProcessorFactory);
        workerConfig.setProcessorFactoryList(processorFactories);
    }
}

