/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.autoconfigure;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.worker.PowerJobSpringWorker;
import tech.powerjob.worker.autoconfigure.PowerJobProperties;
import tech.powerjob.worker.common.PowerJobWorkerConfig;

@Configuration
@EnableConfigurationProperties(value={PowerJobProperties.class})
@ConditionalOnProperty(prefix="powerjob.worker", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class PowerJobAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PowerJobSpringWorker initPowerJob(PowerJobProperties properties) {
        PowerJobProperties.Worker worker = properties.getWorker();
        CommonUtils.requireNonNull((Object)worker.getServerAddress(), (String)"serverAddress can't be empty! if you don't want to enable powerjob, please config program arguments: powerjob.worker.enabled=false");
        List<String> serverAddress = Arrays.asList(worker.getServerAddress().split(","));
        PowerJobWorkerConfig config = new PowerJobWorkerConfig();
        if (worker.getPort() != null) {
            config.setPort(worker.getPort().intValue());
        } else {
            int port = worker.getAkkaPort();
            if (port <= 0) {
                port = NetUtils.getRandomPort();
            }
            config.setPort(port);
        }
        config.setAppName(worker.getAppName());
        config.setServerAddress(serverAddress);
        config.setProtocol(worker.getProtocol());
        config.setStoreStrategy(worker.getStoreStrategy());
        config.setAllowLazyConnectServer(worker.isAllowLazyConnectServer());
        config.setMaxAppendedWfContextLength(worker.getMaxAppendedWfContextLength());
        config.setTag(worker.getTag());
        config.setMaxHeavyweightTaskNum(worker.getMaxHeavyweightTaskNum());
        config.setMaxLightweightTaskNum(worker.getMaxLightweightTaskNum());
        config.setHealthReportInterval(worker.getHealthReportInterval());
        return new PowerJobSpringWorker(config);
    }
}

