/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.samples.processors;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.TaskResult;
import tech.powerjob.worker.core.processor.sdk.BroadcastProcessor;
import tech.powerjob.worker.log.OmsLogger;

@Component
public class BroadcastProcessorDemo
implements BroadcastProcessor {
    private static final Logger log = LoggerFactory.getLogger(BroadcastProcessorDemo.class);

    public ProcessResult preProcess(TaskContext context) {
        System.out.println("===== BroadcastProcessorDemo#preProcess ======");
        context.getOmsLogger().info("BroadcastProcessorDemo#preProcess, current host: {}", new Object[]{NetUtils.getLocalHost()});
        if ("rootFailed".equals(context.getJobParams())) {
            return new ProcessResult(false, "console need failed");
        }
        return new ProcessResult(true);
    }

    public ProcessResult process(TaskContext taskContext) throws Exception {
        OmsLogger logger = taskContext.getOmsLogger();
        System.out.println("===== BroadcastProcessorDemo#process ======");
        logger.info("BroadcastProcessorDemo#process, current host: {}", new Object[]{NetUtils.getLocalHost()});
        long sleepTime = 1000L;
        try {
            sleepTime = Long.parseLong(taskContext.getJobParams());
        }
        catch (Exception e) {
            logger.warn("[BroadcastProcessor] parse sleep time failed!", new Object[]{e});
        }
        Thread.sleep(Math.max(sleepTime, 1000L));
        return new ProcessResult(true);
    }

    public ProcessResult postProcess(TaskContext context, List<TaskResult> taskResults) {
        System.out.println("===== BroadcastProcessorDemo#postProcess ======");
        context.getOmsLogger().info("BroadcastProcessorDemo#postProcess, current host: {}, taskResult: {}", new Object[]{NetUtils.getLocalHost(), taskResults});
        return new ProcessResult(true, "success");
    }
}

