/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import tech.powerjob.server.persistence.QueryConvertUtils;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;
import tech.powerjob.server.persistence.remote.repository.UserInfoRepository;
import tech.powerjob.server.web.converter.UserConverter;
import tech.powerjob.server.web.request.QueryUserRequest;
import tech.powerjob.server.web.response.UserBaseVO;
import tech.powerjob.server.web.service.UserWebService;

@Service
public class UserWebServiceImpl
implements UserWebService {
    private final Cache<Long, UserInfoDO> userCache4Show = CacheBuilder.newBuilder().softValues().maximumSize(256L).expireAfterWrite(3L, TimeUnit.MINUTES).build();
    @Resource
    private UserInfoRepository userInfoRepository;

    @Override
    public Optional<UserBaseVO> fetchBaseUserInfo(Long userId) {
        if (userId == null) {
            return Optional.empty();
        }
        try {
            UserInfoDO userInfoDO = (UserInfoDO)this.userCache4Show.get((Object)userId, () -> {
                Optional userInfoOpt = this.userInfoRepository.findById((Object)userId);
                if (userInfoOpt.isPresent()) {
                    return (UserInfoDO)userInfoOpt.get();
                }
                throw new IllegalArgumentException("can't find user by userId: " + userId);
            });
            return Optional.of(UserConverter.do2BaseVo(userInfoDO, false));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public List<UserInfoDO> list(QueryUserRequest q) {
        Long userIdEq = q.getUserIdEq();
        String accountTypeEq = q.getAccountTypeEq();
        String nickLike = q.getNickLike();
        String phoneLike = q.getPhoneLike();
        Specification & Serializable specification = (Specification & Serializable)(root, query, cb) -> {
            ArrayList predicates = Lists.newArrayList();
            if (userIdEq != null) {
                predicates.add(cb.equal((Expression)root.get("id"), (Object)userIdEq));
            }
            if (StringUtils.isNotEmpty((CharSequence)accountTypeEq)) {
                predicates.add(cb.equal((Expression)root.get("accountType"), (Object)accountTypeEq));
            }
            if (StringUtils.isNotEmpty((CharSequence)nickLike)) {
                predicates.add(cb.like((Expression)root.get("nick"), QueryConvertUtils.convertLikeParams((Object)nickLike)));
            }
            if (StringUtils.isNotEmpty((CharSequence)phoneLike)) {
                predicates.add(cb.like((Expression)root.get("phone"), QueryConvertUtils.convertLikeParams((Object)phoneLike)));
            }
            if (predicates.isEmpty()) {
                return null;
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
        return this.userInfoRepository.findAll((Specification)specification);
    }
}

