/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.response;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;

public class InstanceInfoVO {
    private String jobId;
    private String jobName;
    private String instanceId;
    private String wfInstanceId;
    private String result;
    private String taskTrackerAddress;
    private Long runningTimes;
    private int status;
    private String actualTriggerTime;
    private String finishedTime;

    public static InstanceInfoVO from(InstanceInfoDO instanceInfoDo, String jobName) {
        InstanceInfoVO instanceInfoVO = new InstanceInfoVO();
        BeanUtils.copyProperties((Object)instanceInfoDo, (Object)instanceInfoVO);
        instanceInfoVO.setJobName(jobName);
        instanceInfoVO.setJobId(instanceInfoDo.getJobId().toString());
        instanceInfoVO.setInstanceId(instanceInfoDo.getInstanceId().toString());
        if (instanceInfoDo.getWfInstanceId() == null) {
            instanceInfoVO.setWfInstanceId("N/A");
        } else {
            instanceInfoVO.setWfInstanceId(String.valueOf(instanceInfoDo.getWfInstanceId()));
        }
        if (instanceInfoDo.getActualTriggerTime() == null) {
            instanceInfoVO.setActualTriggerTime("N/A");
        } else {
            instanceInfoVO.setActualTriggerTime(DateFormatUtils.format((long)instanceInfoDo.getActualTriggerTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (instanceInfoDo.getFinishedTime() == null) {
            instanceInfoVO.setFinishedTime("N/A");
        } else {
            instanceInfoVO.setFinishedTime(DateFormatUtils.format((long)instanceInfoDo.getFinishedTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return instanceInfoVO;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getWfInstanceId() {
        return this.wfInstanceId;
    }

    public String getResult() {
        return this.result;
    }

    public String getTaskTrackerAddress() {
        return this.taskTrackerAddress;
    }

    public Long getRunningTimes() {
        return this.runningTimes;
    }

    public int getStatus() {
        return this.status;
    }

    public String getActualTriggerTime() {
        return this.actualTriggerTime;
    }

    public String getFinishedTime() {
        return this.finishedTime;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setTaskTrackerAddress(String taskTrackerAddress) {
        this.taskTrackerAddress = taskTrackerAddress;
    }

    public void setRunningTimes(Long runningTimes) {
        this.runningTimes = runningTimes;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setActualTriggerTime(String actualTriggerTime) {
        this.actualTriggerTime = actualTriggerTime;
    }

    public void setFinishedTime(String finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceInfoVO)) {
            return false;
        }
        InstanceInfoVO other = (InstanceInfoVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$wfInstanceId = this.getWfInstanceId();
        String other$wfInstanceId = other.getWfInstanceId();
        if (this$wfInstanceId == null ? other$wfInstanceId != null : !this$wfInstanceId.equals(other$wfInstanceId)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$taskTrackerAddress = this.getTaskTrackerAddress();
        String other$taskTrackerAddress = other.getTaskTrackerAddress();
        if (this$taskTrackerAddress == null ? other$taskTrackerAddress != null : !this$taskTrackerAddress.equals(other$taskTrackerAddress)) {
            return false;
        }
        Long this$runningTimes = this.getRunningTimes();
        Long other$runningTimes = other.getRunningTimes();
        if (this$runningTimes == null ? other$runningTimes != null : !((Object)this$runningTimes).equals(other$runningTimes)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$actualTriggerTime = this.getActualTriggerTime();
        String other$actualTriggerTime = other.getActualTriggerTime();
        if (this$actualTriggerTime == null ? other$actualTriggerTime != null : !this$actualTriggerTime.equals(other$actualTriggerTime)) {
            return false;
        }
        String this$finishedTime = this.getFinishedTime();
        String other$finishedTime = other.getFinishedTime();
        return !(this$finishedTime == null ? other$finishedTime != null : !this$finishedTime.equals(other$finishedTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstanceInfoVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $wfInstanceId = this.getWfInstanceId();
        result = result * 59 + ($wfInstanceId == null ? 43 : $wfInstanceId.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $taskTrackerAddress = this.getTaskTrackerAddress();
        result = result * 59 + ($taskTrackerAddress == null ? 43 : $taskTrackerAddress.hashCode());
        Long $runningTimes = this.getRunningTimes();
        result = result * 59 + ($runningTimes == null ? 43 : ((Object)$runningTimes).hashCode());
        result = result * 59 + this.getStatus();
        String $actualTriggerTime = this.getActualTriggerTime();
        result = result * 59 + ($actualTriggerTime == null ? 43 : $actualTriggerTime.hashCode());
        String $finishedTime = this.getFinishedTime();
        result = result * 59 + ($finishedTime == null ? 43 : $finishedTime.hashCode());
        return result;
    }

    public String toString() {
        return "InstanceInfoVO(jobId=" + this.getJobId() + ", jobName=" + this.getJobName() + ", instanceId=" + this.getInstanceId() + ", wfInstanceId=" + this.getWfInstanceId() + ", result=" + this.getResult() + ", taskTrackerAddress=" + this.getTaskTrackerAddress() + ", runningTimes=" + this.getRunningTimes() + ", status=" + this.getStatus() + ", actualTriggerTime=" + this.getActualTriggerTime() + ", finishedTime=" + this.getFinishedTime() + ")";
    }
}

