/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.enums.WorkflowInstanceStatus;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.core.service.CacheService;
import tech.powerjob.server.core.workflow.WorkflowInstanceService;
import tech.powerjob.server.persistence.PageResult;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInstanceInfoRepository;
import tech.powerjob.server.web.request.QueryWorkflowInstanceRequest;
import tech.powerjob.server.web.response.WorkflowInstanceInfoVO;

@RestController
@RequestMapping(value={"/wfInstance"})
public class WorkflowInstanceController {
    @Resource
    private CacheService cacheService;
    @Resource
    private WorkflowInstanceService workflowInstanceService;
    @Resource
    private WorkflowInstanceInfoRepository workflowInstanceInfoRepository;

    @GetMapping(value={"/stop"})
    @ApiPermission(name="WorkflowInstance-Stop", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<Void> stopWfInstance(Long wfInstanceId, Long appId) {
        this.workflowInstanceService.stopWorkflowInstanceEntrance(wfInstanceId, appId);
        return ResultDTO.success(null);
    }

    @RequestMapping(value={"/retry"})
    @ApiPermission(name="WorkflowInstance-Retry", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<Void> retryWfInstance(Long wfInstanceId, Long appId) {
        this.workflowInstanceService.retryWorkflowInstance(wfInstanceId, appId);
        return ResultDTO.success(null);
    }

    @RequestMapping(value={"/markNodeAsSuccess"})
    @ApiPermission(name="WorkflowInstance-MarkNodeAsSuccess", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<Void> markNodeAsSuccess(Long wfInstanceId, Long appId, Long nodeId) {
        this.workflowInstanceService.markNodeAsSuccess(appId, wfInstanceId, nodeId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/info"})
    @ApiPermission(name="WorkflowInstance-Info", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public ResultDTO<WorkflowInstanceInfoVO> getInfo(Long wfInstanceId, Long appId) {
        WorkflowInstanceInfoDO wfInstanceDO = this.workflowInstanceService.fetchWfInstance(wfInstanceId, appId);
        return ResultDTO.success((Object)WorkflowInstanceInfoVO.from(wfInstanceDO, this.cacheService.getWorkflowName(wfInstanceDO.getWorkflowId())));
    }

    @PostMapping(value={"/list"})
    @ApiPermission(name="WorkflowInstance-List", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public ResultDTO<PageResult<WorkflowInstanceInfoVO>> listWfInstance(@RequestBody QueryWorkflowInstanceRequest req) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"gmtModified"});
        PageRequest pageable = PageRequest.of((int)req.getIndex(), (int)req.getPageSize(), (Sort)sort);
        WorkflowInstanceInfoDO queryEntity = new WorkflowInstanceInfoDO();
        BeanUtils.copyProperties((Object)req, (Object)queryEntity);
        if (!StringUtils.isEmpty((CharSequence)req.getStatus())) {
            queryEntity.setStatus(Integer.valueOf(WorkflowInstanceStatus.valueOf((String)req.getStatus()).getV()));
        }
        Page ps = this.workflowInstanceInfoRepository.findAll(Example.of((Object)queryEntity), (Pageable)pageable);
        return ResultDTO.success(this.convertPage((Page<WorkflowInstanceInfoDO>)ps));
    }

    private PageResult<WorkflowInstanceInfoVO> convertPage(Page<WorkflowInstanceInfoDO> ps) {
        PageResult pr = new PageResult(ps);
        pr.setData(ps.getContent().stream().map(x -> WorkflowInstanceInfoVO.from(x, this.cacheService.getWorkflowName(x.getWorkflowId()))).collect(Collectors.toList()));
        return pr;
    }
}

