/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.core.scheduler.TimingStrategyService;

@RestController
@RequestMapping(value={"/validate"})
public class ValidateController {
    private final TimingStrategyService timingStrategyService;

    @GetMapping(value={"/timeExpression"})
    public ResultDTO<List<String>> checkTimeExpression(TimeExpressionType timeExpressionType, String timeExpression, @RequestParam(required=false) Long startTime, @RequestParam(required=false) Long endTime) {
        try {
            this.timingStrategyService.validate(timeExpressionType, timeExpression, startTime, endTime);
            return ResultDTO.success((Object)this.timingStrategyService.calculateNextTriggerTimes(timeExpressionType, timeExpression, startTime, endTime));
        }
        catch (Exception e) {
            return ResultDTO.success((Object)Lists.newArrayList((Object[])new String[]{ExceptionUtils.getMessage((Throwable)e)}));
        }
    }

    public ValidateController(TimingStrategyService timingStrategyService) {
        this.timingStrategyService = timingStrategyService;
    }
}

