/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.enums.ErrorCodes;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.Role;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.common.PowerJobAuthException;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.auth.service.WebAuthService;
import tech.powerjob.server.auth.service.login.PowerJobLoginService;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.model.NamespaceDO;
import tech.powerjob.server.persistence.remote.model.UserInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.persistence.remote.repository.NamespaceRepository;
import tech.powerjob.server.persistence.remote.repository.UserInfoRepository;
import tech.powerjob.server.web.converter.NamespaceConverter;
import tech.powerjob.server.web.converter.UserConverter;
import tech.powerjob.server.web.request.ModifyUserInfoRequest;
import tech.powerjob.server.web.request.QueryUserRequest;
import tech.powerjob.server.web.response.AppBaseVO;
import tech.powerjob.server.web.response.NamespaceBaseVO;
import tech.powerjob.server.web.response.UserBaseVO;
import tech.powerjob.server.web.response.UserDetailVO;
import tech.powerjob.server.web.service.UserWebService;

@RestController
@RequestMapping(value={"/user"})
public class UserInfoController {
    private static final Logger log = LoggerFactory.getLogger(UserInfoController.class);
    @Resource
    private UserWebService userWebService;
    @Resource
    private UserInfoRepository userInfoRepository;
    @Resource
    private PowerJobLoginService powerJobLoginService;
    @Resource
    private WebAuthService webAuthService;
    @Resource
    private NamespaceRepository namespaceRepository;
    @Resource
    private AppInfoRepository appInfoRepository;

    @PostMapping(value={"/modify"})
    public ResultDTO<Void> modifyUser(@RequestBody ModifyUserInfoRequest modifyUserInfoRequest, HttpServletRequest httpServletRequest) {
        Long userId = modifyUserInfoRequest.getId();
        this.checkModifyUserPermission(userId, httpServletRequest);
        Optional userOpt = this.userInfoRepository.findById((Object)userId);
        if (!userOpt.isPresent()) {
            throw new IllegalArgumentException("can't find user by userId:" + userId);
        }
        UserInfoDO dbUser = (UserInfoDO)userOpt.get();
        if (StringUtils.isNotEmpty((CharSequence)modifyUserInfoRequest.getNick())) {
            dbUser.setNick(modifyUserInfoRequest.getNick());
        }
        if (StringUtils.isNotEmpty((CharSequence)modifyUserInfoRequest.getPhone())) {
            dbUser.setPhone(modifyUserInfoRequest.getPhone());
        }
        if (StringUtils.isNotEmpty((CharSequence)modifyUserInfoRequest.getEmail())) {
            dbUser.setEmail(modifyUserInfoRequest.getEmail());
        }
        if (StringUtils.isNotEmpty((CharSequence)modifyUserInfoRequest.getWebHook())) {
            dbUser.setWebHook(modifyUserInfoRequest.getWebHook());
        }
        if (StringUtils.isNotEmpty((CharSequence)modifyUserInfoRequest.getExtra())) {
            dbUser.setExtra(modifyUserInfoRequest.getExtra());
        }
        dbUser.setGmtModified(new Date());
        this.userInfoRepository.saveAndFlush((Object)dbUser);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/list"})
    public ResultDTO<List<UserBaseVO>> list(@RequestParam(required=false) String name) {
        List result = StringUtils.isEmpty((CharSequence)name) ? this.userInfoRepository.findAll() : this.userInfoRepository.findByUsernameLike("%" + name + "%");
        return ResultDTO.success(UserInfoController.convert(result));
    }

    @PostMapping(value={"/query"})
    @ApiPermission(name="User-Query", roleScope=RoleScope.GLOBAL, requiredPermission=Permission.SU)
    public ResultDTO<List<UserBaseVO>> query(@RequestBody QueryUserRequest queryUserRequest) {
        List<UserInfoDO> userInfoDos = this.userWebService.list(queryUserRequest);
        List userBaseVOS = userInfoDos.stream().map(x -> UserConverter.do2BaseVo(x, true)).collect(Collectors.toList());
        return ResultDTO.success(userBaseVOS);
    }

    @GetMapping(value={"/detail"})
    public ResultDTO<UserDetailVO> getUserDetail(HttpServletRequest httpServletRequest) {
        Optional powerJobUserOpt = this.powerJobLoginService.ifLogin(httpServletRequest);
        if (!powerJobUserOpt.isPresent()) {
            throw new PowerJobAuthException(ErrorCodes.USER_NOT_LOGIN);
        }
        Optional userinfoDoOpt = this.userInfoRepository.findById((Object)((PowerJobUser)powerJobUserOpt.get()).getId());
        if (!userinfoDoOpt.isPresent()) {
            throw new IllegalArgumentException("can't find user by id: " + ((PowerJobUser)powerJobUserOpt.get()).getId());
        }
        UserDetailVO userDetailVO = new UserDetailVO();
        BeanUtils.copyProperties(userinfoDoOpt.get(), (Object)userDetailVO);
        userDetailVO.genShowName();
        Map<Role, List<Long>> globalPermissions = this.webAuthService.fetchMyPermissionTargets(RoleScope.GLOBAL);
        userDetailVO.setGlobalRoles(globalPermissions.keySet().stream().map(Enum::name).collect(Collectors.toList()));
        Map<Role, List<Long>> namespacePermissions = this.webAuthService.fetchMyPermissionTargets(RoleScope.NAMESPACE);
        List nsList = this.namespaceRepository.findAllByIdIn(UserInfoController.mergeIds(namespacePermissions));
        HashMap id2NamespaceDo = Maps.newHashMap();
        nsList.forEach(x -> id2NamespaceDo.put(x.getId(), x));
        HashMap role2NamespaceBaseVo = Maps.newHashMap();
        namespacePermissions.forEach((k, v) -> {
            ArrayList namespaceBaseVOS = Lists.newArrayList();
            role2NamespaceBaseVo.put(k.name(), namespaceBaseVOS);
            v.forEach(nId -> {
                NamespaceDO namespaceDO = (NamespaceDO)id2NamespaceDo.get(nId);
                if (namespaceDO == null) {
                    return;
                }
                NamespaceBaseVO namespaceBaseVO = NamespaceConverter.do2BaseVo(namespaceDO);
                namespaceBaseVOS.add(namespaceBaseVO);
            });
        });
        userDetailVO.setRole2NamespaceList(role2NamespaceBaseVo);
        Map<Role, List<Long>> appPermissions = this.webAuthService.fetchMyPermissionTargets(RoleScope.APP);
        List appList = this.appInfoRepository.findAllByIdIn(UserInfoController.mergeIds(appPermissions));
        HashMap id2AppInfo = Maps.newHashMap();
        appList.forEach(x -> id2AppInfo.put(x.getId(), x));
        HashMap role2AppBaseVo = Maps.newHashMap();
        appPermissions.forEach((k, v) -> {
            ArrayList appBaseVOS = Lists.newArrayList();
            role2AppBaseVo.put(k.name(), appBaseVOS);
            v.forEach(nId -> {
                AppInfoDO appInfoDO = (AppInfoDO)id2AppInfo.get(nId);
                if (appInfoDO == null) {
                    return;
                }
                AppBaseVO appBaseVO = new AppBaseVO();
                BeanUtils.copyProperties((Object)appInfoDO, (Object)appBaseVO);
                appBaseVOS.add(appBaseVO);
            });
        });
        userDetailVO.setRole2AppList(role2AppBaseVo);
        return ResultDTO.success((Object)userDetailVO);
    }

    @PostMapping(value={"/disable"})
    public ResultDTO<Void> disableUser(Long uid, HttpServletRequest httpServletRequest) {
        this.changeAccountStatus(uid, SwitchableStatus.DISABLE, httpServletRequest);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/enable"})
    public ResultDTO<Void> enableUser(Long uid, HttpServletRequest httpServletRequest) {
        this.changeAccountStatus(uid, SwitchableStatus.ENABLE, httpServletRequest);
        return ResultDTO.success(null);
    }

    private void changeAccountStatus(Long uid, SwitchableStatus targetStatus, HttpServletRequest httpServletRequest) {
        this.checkModifyUserPermission(uid, httpServletRequest);
        Optional userOpt = this.userInfoRepository.findById((Object)uid);
        if (!userOpt.isPresent()) {
            throw new IllegalArgumentException("can't find user by userId:" + uid);
        }
        UserInfoDO dbUser = (UserInfoDO)userOpt.get();
        dbUser.setStatus(Integer.valueOf(targetStatus.getV()));
        dbUser.setGmtModified(new Date());
        this.userInfoRepository.saveAndFlush((Object)dbUser);
        log.info("[UserInfoController] changeAccountStatus, userId={},targetStatus={}", (Object)uid, (Object)targetStatus);
    }

    private void checkModifyUserPermission(Long uid, HttpServletRequest httpServletRequest) {
        Optional powerJobUserOpt = this.powerJobLoginService.ifLogin(httpServletRequest);
        if (!powerJobUserOpt.isPresent()) {
            throw new PowerJobAuthException(ErrorCodes.USER_NOT_LOGIN);
        }
        PowerJobUser currentLoginUser = (PowerJobUser)powerJobUserOpt.get();
        boolean myself = uid.equals(currentLoginUser.getId());
        boolean globalAdmin = this.webAuthService.isGlobalAdmin();
        if (myself || globalAdmin) {
            return;
        }
        throw new PowerJobException("Only the administrator and account owner can modify the account");
    }

    private static List<UserBaseVO> convert(List<UserInfoDO> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newLinkedList();
        }
        return data.stream().map(x -> UserConverter.do2BaseVo(x, false)).collect(Collectors.toList());
    }

    private static Set<Long> mergeIds(Map<?, List<Long>> map) {
        HashSet ids = Sets.newHashSet();
        map.values().forEach(ids::addAll);
        return ids;
    }
}

