/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.auth.plugin.ModifyOrCreateDynamicPermission;
import tech.powerjob.server.auth.plugin.SaveNamespaceGrantPermissionPlugin;
import tech.powerjob.server.auth.service.WebAuthService;
import tech.powerjob.server.persistence.PageResult;
import tech.powerjob.server.persistence.remote.model.NamespaceDO;
import tech.powerjob.server.web.converter.NamespaceConverter;
import tech.powerjob.server.web.request.ComponentUserRoleInfo;
import tech.powerjob.server.web.request.ModifyNamespaceRequest;
import tech.powerjob.server.web.request.QueryNamespaceRequest;
import tech.powerjob.server.web.response.NamespaceBaseVO;
import tech.powerjob.server.web.response.NamespaceVO;
import tech.powerjob.server.web.response.UserBaseVO;
import tech.powerjob.server.web.service.NamespaceWebService;
import tech.powerjob.server.web.service.UserWebService;

@RestController
@RequestMapping(value={"/namespace"})
public class NamespaceController {
    private static final Logger log = LoggerFactory.getLogger(NamespaceController.class);
    @Resource
    private WebAuthService webAuthService;
    @Resource
    private UserWebService userWebService;
    @Resource
    private NamespaceWebService namespaceWebService;

    @ResponseBody
    @PostMapping(value={"/save"})
    @ApiPermission(name="Namespace-Save", roleScope=RoleScope.NAMESPACE, dynamicPermissionPlugin=ModifyOrCreateDynamicPermission.class, grandPermissionPlugin=SaveNamespaceGrantPermissionPlugin.class)
    public ResultDTO<NamespaceBaseVO> save(@RequestBody ModifyNamespaceRequest req) {
        NamespaceDO savedNamespace = this.namespaceWebService.save(req);
        return ResultDTO.success((Object)NamespaceConverter.do2BaseVo(savedNamespace));
    }

    @DeleteMapping(value={"/delete"})
    @ApiPermission(name="Namespace-Delete", roleScope=RoleScope.NAMESPACE, requiredPermission=Permission.SU)
    public ResultDTO<Void> deleteNamespace(Long id) {
        this.namespaceWebService.delete(id);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/list"})
    @ApiPermission(name="Namespace-List", roleScope=RoleScope.NAMESPACE, requiredPermission=Permission.NONE)
    public ResultDTO<PageResult<NamespaceVO>> listNamespace(@RequestBody QueryNamespaceRequest queryNamespaceRequest) {
        Page<NamespaceDO> namespacePageResult = this.namespaceWebService.list(queryNamespaceRequest);
        PageResult ret = new PageResult(namespacePageResult);
        ret.setData(namespacePageResult.get().map(x -> {
            NamespaceVO detailVo = new NamespaceVO();
            NamespaceBaseVO baseVO = NamespaceConverter.do2BaseVo(x);
            BeanUtils.copyProperties((Object)baseVO, (Object)detailVo);
            this.fillDetail((NamespaceDO)x, detailVo);
            return detailVo;
        }).collect(Collectors.toList()));
        return ResultDTO.success((Object)ret);
    }

    @PostMapping(value={"/listAll"})
    @ApiPermission(name="Namespace-ListAll", roleScope=RoleScope.NAMESPACE, requiredPermission=Permission.NONE)
    public ResultDTO<List<NamespaceBaseVO>> listAll() {
        List<NamespaceDO> namespaceRepositoryAll = this.namespaceWebService.listAll();
        List namespaceBaseVOList = namespaceRepositoryAll.stream().map(nd -> {
            NamespaceBaseVO nv = new NamespaceBaseVO();
            nv.setId(nd.getId());
            nv.setCode(nd.getCode());
            nv.setName(nd.getName());
            nv.genShowName();
            return nv;
        }).collect(Collectors.toList());
        return ResultDTO.success(namespaceBaseVOList);
    }

    private void fillDetail(NamespaceDO namespaceDO, NamespaceVO namespaceVO) {
        Long namespaceId = namespaceVO.getId();
        ComponentUserRoleInfo componentUserRoleInfo = this.webAuthService.fetchComponentUserRoleInfo(RoleScope.NAMESPACE, namespaceId);
        namespaceVO.setComponentUserRoleInfo(componentUserRoleInfo);
        boolean hasPermission = this.webAuthService.hasPermission(RoleScope.NAMESPACE, namespaceId, Permission.READ);
        namespaceVO.setToken(hasPermission ? namespaceDO.getToken() : "NO_PERMISSION_TO_SEE");
        namespaceVO.setCreatorShowName(this.userWebService.fetchBaseUserInfo(namespaceDO.getCreator()).map(UserBaseVO::getShowName).orElse(null));
        namespaceVO.setModifierShowName(this.userWebService.fetchBaseUserInfo(namespaceDO.getModifier()).map(UserBaseVO::getShowName).orElse(null));
    }
}

