/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.common.AuthConstants;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.auth.login.LoginTypeInfo;
import tech.powerjob.server.auth.service.WebAuthService;
import tech.powerjob.server.auth.service.login.LoginRequest;
import tech.powerjob.server.auth.service.login.PowerJobLoginService;
import tech.powerjob.server.web.request.ComponentUserRoleInfo;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    @Resource
    private WebAuthService webAuthService;
    @Resource
    private PowerJobLoginService powerJobLoginService;

    @GetMapping(value={"/supportLoginTypes"})
    public ResultDTO<List<LoginTypeInfo>> listSupportLoginTypes() {
        return ResultDTO.success((Object)this.powerJobLoginService.fetchSupportLoginTypes());
    }

    @GetMapping(value={"/thirdPartyLoginUrl"})
    public ResultDTO<String> getThirdPartyLoginUrl(String type, HttpServletRequest request) {
        String url = this.powerJobLoginService.fetchThirdPartyLoginUrl(type, request);
        return ResultDTO.success((Object)url);
    }

    @RequestMapping(value={"/thirdPartyLoginCallback"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResultDTO<PowerJobUser> loginCallback(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        LoginRequest loginContext = new LoginRequest().setHttpServletRequest(httpServletRequest);
        String state = httpServletRequest.getParameter("state");
        loginContext.setLoginType(state);
        PowerJobUser powerJobUser = this.powerJobLoginService.doLogin(loginContext);
        this.fillJwt4LoginUser(powerJobUser, httpServletResponse);
        return ResultDTO.success((Object)powerJobUser);
    }

    @PostMapping(value={"/thirdPartyLoginDirect"})
    public ResultDTO<PowerJobUser> selfLogin(@RequestBody LoginRequest loginRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        loginRequest.setHttpServletRequest(httpServletRequest);
        try {
            PowerJobUser powerJobUser = this.powerJobLoginService.doLogin(loginRequest);
            if (powerJobUser == null) {
                return ResultDTO.failed((String)"USER_NOT_FOUND");
            }
            this.fillJwt4LoginUser(powerJobUser, httpServletResponse);
            return ResultDTO.success((Object)powerJobUser);
        }
        catch (Exception e) {
            return ResultDTO.failed((String)e.getMessage());
        }
    }

    @GetMapping(value={"/ifLogin"})
    public ResultDTO<PowerJobUser> ifLogin(HttpServletRequest httpServletRequest) {
        Optional powerJobUser = this.powerJobLoginService.ifLogin(httpServletRequest);
        return powerJobUser.map(ResultDTO::success).orElseGet(() -> ResultDTO.success(null));
    }

    @GetMapping(value={"/listGlobalAdmin"})
    public ResultDTO<List<Long>> listGlobalAdmin() {
        ComponentUserRoleInfo componentUserRoleInfo = this.webAuthService.fetchComponentUserRoleInfo(RoleScope.GLOBAL, AuthConstants.GLOBAL_ADMIN_TARGET_ID);
        return ResultDTO.success(componentUserRoleInfo.getAdmin());
    }

    @PostMapping(value={"/saveGlobalAdmin"})
    @ApiPermission(name="Auth-SaveGlobalAdmin", roleScope=RoleScope.GLOBAL, requiredPermission=Permission.SU)
    public ResultDTO<Void> saveGlobalAdmin(@RequestBody ComponentUserRoleInfo componentUserRoleInfo) {
        if (CollectionUtils.isEmpty(componentUserRoleInfo.getAdmin())) {
            throw new IllegalArgumentException("At least one super administrator is required!");
        }
        this.webAuthService.processPermissionOnSave(RoleScope.GLOBAL, AuthConstants.GLOBAL_ADMIN_TARGET_ID, componentUserRoleInfo);
        return ResultDTO.success(null);
    }

    private void fillJwt4LoginUser(PowerJobUser powerJobUser, HttpServletResponse httpServletResponse) {
        httpServletResponse.addCookie(new Cookie("PowerJwt", powerJobUser.getJwtToken()));
    }
}

