/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.messaging.handler.annotation.support.MethodArgumentTypeMismatchException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.PowerResultDTO;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public PowerResultDTO<Void> exceptionHandler(Exception e) {
        PowerResultDTO ret = PowerResultDTO.f((String)ExceptionUtils.getMessage((Throwable)e));
        if (e instanceof PowerJobException) {
            ret.setCode(((PowerJobException)e).getCode());
            log.warn("[ControllerException] PowerJobException, message is {}.", (Object)e.getMessage());
        } else if (e instanceof IllegalArgumentException) {
            log.warn("[ControllerException] http request failed due to IllegalArgument, message is {}.", (Object)e.getMessage());
        } else if (e instanceof HttpMessageNotReadableException || e instanceof MethodArgumentTypeMismatchException) {
            log.warn("[ControllerException] invalid http request params, exception is {}.", (Object)e.getMessage());
        } else if (e instanceof HttpRequestMethodNotSupportedException) {
            log.warn("[ControllerException] invalid http request method, exception is {}.", (Object)e.getMessage());
        } else {
            log.error("[ControllerException] http request failed.", (Throwable)e);
        }
        return ret;
    }
}

