/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.openapi.security;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.client.module.AppAuthRequest;
import tech.powerjob.client.module.AppAuthResult;
import tech.powerjob.common.enums.ErrorCodes;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.auth.common.utils.HttpServletUtils;
import tech.powerjob.server.auth.jwt.JwtService;
import tech.powerjob.server.auth.jwt.ParseResult;
import tech.powerjob.server.core.service.AppInfoService;
import tech.powerjob.server.openapi.security.OpenApiSecurityService;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;

@Service
public class OpenApiSecurityServiceImpl
implements OpenApiSecurityService {
    private static final Logger log = LoggerFactory.getLogger(OpenApiSecurityServiceImpl.class);
    @Resource
    private JwtService jwtService;
    @Resource
    private AppInfoService appInfoService;
    private static final String JWT_KEY_APP_ID = "appId";
    private static final String JWT_KEY_APP_PASSWORD = "password";
    private static final String JWT_KEY_ENCRYPT_TYPE = "encryptType";

    @Override
    public void authAppByToken(HttpServletRequest httpServletRequest) {
        String token = HttpServletUtils.fetchFromHeader((String)"X-POWERJOB-ACCESS-TOKEN", (HttpServletRequest)httpServletRequest);
        String appIdFromHeader = HttpServletUtils.fetchFromHeader((String)"X-POWERJOB-APP-ID", (HttpServletRequest)httpServletRequest);
        if (StringUtils.isEmpty((CharSequence)appIdFromHeader)) {
            throw new PowerJobException(ErrorCodes.INVALID_REQUEST, "lack_of_appId_in_header");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new PowerJobException(ErrorCodes.OPEN_API_AUTH_FAILED, "token_is_empty");
        }
        ParseResult parseResult = this.jwtService.parse(token, null);
        switch (parseResult.getStatus()) {
            case EXPIRED: {
                throw new PowerJobException(ErrorCodes.TOKEN_EXPIRED, parseResult.getMsg());
            }
            case FAILED: {
                throw new PowerJobException(ErrorCodes.INVALID_TOKEN, parseResult.getMsg());
            }
        }
        Map jwtResult = parseResult.getResult();
        Long appIdFromJwt = MapUtils.getLong((Map)jwtResult, (Object)JWT_KEY_APP_ID);
        String passwordFromJwt = MapUtils.getString((Map)jwtResult, (Object)JWT_KEY_APP_PASSWORD);
        String encryptType = MapUtils.getString((Map)jwtResult, (Object)JWT_KEY_ENCRYPT_TYPE);
        if (!StringUtils.equals((CharSequence)appIdFromHeader, (CharSequence)String.valueOf(appIdFromJwt))) {
            throw new PowerJobException(ErrorCodes.INVALID_REQUEST, "Inconsistent_appId_from_token_and_header");
        }
        Optional appInfoOpt = this.appInfoService.findById(appIdFromJwt, true);
        if (!appInfoOpt.isPresent()) {
            throw new PowerJobException(ErrorCodes.INVALID_APP, "can_not_find_app");
        }
        this.appInfoService.assertApp((AppInfoDO)appInfoOpt.get(), passwordFromJwt, encryptType);
    }

    @Override
    public AppAuthResult authAppByParam(AppAuthRequest appAuthRequest) {
        String appName = appAuthRequest.getAppName();
        String encryptedPassword = appAuthRequest.getEncryptedPassword();
        Long appId = this.appInfoService.assertApp(appName, encryptedPassword, appAuthRequest.getEncryptType());
        HashMap jwtBody = Maps.newHashMap();
        jwtBody.put(JWT_KEY_APP_ID, appId);
        jwtBody.put(JWT_KEY_APP_PASSWORD, encryptedPassword);
        jwtBody.put(JWT_KEY_ENCRYPT_TYPE, appAuthRequest.getEncryptType());
        AppAuthResult appAuthResult = new AppAuthResult();
        appAuthResult.setAppId(appId);
        appAuthResult.setToken(this.jwtService.build((Map)jwtBody, null));
        return appAuthResult;
    }
}

