/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.openapi;

import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.PowerResultDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.openapi.security.OpenApiSecurityService;

@Component
public class OpenApiInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OpenApiInterceptor.class);
    @Resource
    private OpenApiSecurityService openApiSecurityService;
    @Value(value="${oms.auth.openapi.enable:false}")
    private boolean enableOpenApiAuth;
    private static final Set<String> IGNORE_OPEN_API_PATH = Sets.newHashSet((Object[])new String[]{"/assert", "/authApp"});

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (!this.enableOpenApiAuth) {
            return true;
        }
        String requestURI = request.getRequestURI();
        for (String endPath : IGNORE_OPEN_API_PATH) {
            if (!requestURI.endsWith(endPath)) continue;
            return true;
        }
        try {
            this.openApiSecurityService.authAppByToken(request);
            response.addHeader("X-POWERJOB-AUTH-PASSED", Boolean.TRUE.toString());
        }
        catch (PowerJobException pje) {
            response.addHeader("X-POWERJOB-AUTH-PASSED", Boolean.FALSE.toString());
            this.writeResponse((PowerResultDTO<Object>)PowerResultDTO.f((PowerJobException)pje), response);
            return false;
        }
        catch (Exception e) {
            response.setStatus(500);
            this.writeResponse((PowerResultDTO<Object>)PowerResultDTO.f((Throwable)e), response);
            log.error("[OpenApiInterceptor] unknown exception when auth app by token", (Throwable)e);
            return false;
        }
        return true;
    }

    private void writeResponse(PowerResultDTO<Object> powerResult, HttpServletResponse response) {
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.write(JsonUtils.toJSONString(powerResult));
        writer.flush();
    }
}

