/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.initializer;

import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.initializer.SystemInitializeService;
import tech.powerjob.server.persistence.remote.model.SundryDO;
import tech.powerjob.server.persistence.remote.repository.SundryRepository;

@Component
public class NewSystemInitializer
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(NewSystemInitializer.class);
    private static final String LOCK_PREFIX = "sys_init_lock_";
    private static final int MAX_LOCK_TIME = 5000;
    @Resource
    private LockService lockService;
    @Resource
    private SundryRepository sundryRepository;
    @Resource
    private SystemInitializeService systemInitializeService;
    private static final String SUNDRY_PKEY = "sys_initialize";

    public void run(String ... args) throws Exception {
        this.initSystemAdmin();
        this.initDefaultNamespace();
    }

    private void initSystemAdmin() {
        this.clusterInit("goal_init_admin", Void2 -> this.systemInitializeService.initAdmin());
    }

    private void initDefaultNamespace() {
        this.clusterInit("goal_init_namespace", Void2 -> this.systemInitializeService.initNamespace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clusterInit(String name, Consumer<Void> initFunc) {
        Optional sundryOpt = this.sundryRepository.findByPkeyAndSkey(SUNDRY_PKEY, name);
        if (sundryOpt.isPresent()) {
            log.info("[NewSystemInitializer] already initialized, skip: {}", (Object)name);
            return;
        }
        String lockName = LOCK_PREFIX.concat(name);
        while (true) {
            try {
                boolean lockStatus = this.lockService.tryLock(lockName, 5000L);
                Optional sundryOpt2 = this.sundryRepository.findByPkeyAndSkey(SUNDRY_PKEY, name);
                if (sundryOpt2.isPresent()) {
                    log.info("[NewSystemInitializer] other server finished initialize, skip process: {}", (Object)name);
                    break;
                }
                if (!lockStatus) {
                    CommonUtils.easySleep((long)277L);
                    continue;
                }
                log.info("[NewSystemInitializer] try to initialize: {}", (Object)name);
                initFunc.accept(null);
                log.info("[NewSystemInitializer] initialize [{}] successfully!", (Object)name);
                SundryDO sundryDO = new SundryDO();
                sundryDO.setPkey(SUNDRY_PKEY);
                sundryDO.setSkey(name);
                sundryDO.setContent("A");
                sundryDO.setGmtCreate(new Date());
                this.sundryRepository.saveAndFlush((Object)sundryDO);
                log.info("[NewSystemInitializer] write initialized tag successfully: {}", (Object)sundryDO);
            }
            finally {
                this.lockService.unlock(lockName);
                continue;
            }
            break;
        }
    }
}

