/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.powerjob.server.remote.server.self.ServerInfoService;

@Configuration
@ConditionalOnProperty(name={"oms.swagger.enable"}, havingValue="true")
public class SwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    private final ServerInfoService serverInfoService;

    @Bean
    public OpenAPI springShopOpenAPI() {
        Contact contact = new Contact();
        contact.setName("Team PowerJob");
        contact.setUrl("http://www.powerjob.tech");
        contact.setEmail("tengjiqi@gmail.com");
        return new OpenAPI().info(new Info().title("PowerJob").description("Distributed scheduling and computing framework.").version(this.serverInfoService.fetchCurrentServerInfo().getVersion()).contact(contact).license(new License().name("Apache License 2.0").url("https://github.com/PowerJob/PowerJob/blob/master/LICENSE")));
    }

    @Bean
    public GroupedOpenApi createRestApi() {
        log.warn("[OpenAPI] openapi has been activated, make sure you want to enable it!");
        return GroupedOpenApi.builder().group("PowerJob-ALL").pathsToMatch(new String[]{"/**"}).build();
    }

    public SwaggerConfig(ServerInfoService serverInfoService) {
        this.serverInfoService = serverInfoService;
    }
}

