/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.ErrorCodes;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.auth.LoginUserHolder;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.Role;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.common.AuthConstants;
import tech.powerjob.server.auth.common.PowerJobAuthException;
import tech.powerjob.server.auth.service.WebAuthService;
import tech.powerjob.server.auth.service.permission.PowerJobPermissionService;
import tech.powerjob.server.web.request.ComponentUserRoleInfo;

@Service
public class WebAuthServiceImpl
implements WebAuthService {
    private static final Logger log = LoggerFactory.getLogger(WebAuthServiceImpl.class);
    @Resource
    private PowerJobPermissionService powerJobPermissionService;

    @Override
    public void grantRole2LoginUser(RoleScope roleScope, Long target, Role role, String extra) {
        Long userId = LoginUserHolder.getUserId();
        if (userId == null) {
            throw new PowerJobAuthException(ErrorCodes.USER_NOT_LOGIN);
        }
        this.powerJobPermissionService.grantRole(roleScope, target, userId, role, extra);
    }

    @Override
    public void processPermissionOnSave(RoleScope roleScope, Long target, ComponentUserRoleInfo o) {
        ComponentUserRoleInfo componentUserRoleInfo = Optional.ofNullable(o).orElse(new ComponentUserRoleInfo());
        Map role2Uids = this.powerJobPermissionService.fetchUserWithPermissions(roleScope, target);
        this.diffGrant(roleScope, target, Role.OBSERVER, componentUserRoleInfo.getObserver(), role2Uids);
        this.diffGrant(roleScope, target, Role.QA, componentUserRoleInfo.getQa(), role2Uids);
        this.diffGrant(roleScope, target, Role.DEVELOPER, componentUserRoleInfo.getDeveloper(), role2Uids);
        this.diffGrant(roleScope, target, Role.ADMIN, componentUserRoleInfo.getAdmin(), role2Uids);
    }

    @Override
    public ComponentUserRoleInfo fetchComponentUserRoleInfo(RoleScope roleScope, Long target) {
        Map role2Uids = this.powerJobPermissionService.fetchUserWithPermissions(roleScope, target);
        return new ComponentUserRoleInfo().setObserver(Lists.newArrayList((Iterable)role2Uids.getOrDefault(Role.OBSERVER, Collections.emptySet()))).setQa(Lists.newArrayList((Iterable)role2Uids.getOrDefault(Role.QA, Collections.emptySet()))).setDeveloper(Lists.newArrayList((Iterable)role2Uids.getOrDefault(Role.DEVELOPER, Collections.emptySet()))).setAdmin(Lists.newArrayList((Iterable)role2Uids.getOrDefault(Role.ADMIN, Collections.emptySet())));
    }

    @Override
    public boolean hasPermission(RoleScope roleScope, Long target, Permission permission) {
        PowerJobUser powerJobUser = LoginUserHolder.get();
        if (powerJobUser == null) {
            return false;
        }
        return this.powerJobPermissionService.hasPermission(powerJobUser.getId(), roleScope, target, permission);
    }

    @Override
    public boolean isGlobalAdmin() {
        return this.hasPermission(RoleScope.GLOBAL, AuthConstants.GLOBAL_ADMIN_TARGET_ID, Permission.SU);
    }

    @Override
    public Map<Role, List<Long>> fetchMyPermissionTargets(RoleScope roleScope) {
        PowerJobUser powerJobUser = LoginUserHolder.get();
        if (powerJobUser == null) {
            throw new PowerJobAuthException(ErrorCodes.USER_NOT_LOGIN);
        }
        return this.powerJobPermissionService.fetchUserHadPermissionTargets(roleScope, powerJobUser.getId());
    }

    private void diffGrant(RoleScope roleScope, Long target, Role role, List<Long> uids, Map<Role, Set<Long>> originRole2Uids) {
        HashSet originUids = Sets.newHashSet((Iterable)Optional.ofNullable(originRole2Uids.get(role)).orElse(Collections.emptySet()));
        HashSet currentUids = Sets.newHashSet((Iterable)Optional.ofNullable(uids).orElse(Collections.emptyList()));
        HashMap extraInfo = Maps.newHashMap();
        extraInfo.put("grantor", LoginUserHolder.getUserName());
        extraInfo.put("source", "diffGrant");
        String extra = JsonUtils.toJSONString((Object)extraInfo);
        HashSet allIds = Sets.newHashSet((Iterable)originUids);
        allIds.addAll(currentUids);
        HashSet allIds2 = Sets.newHashSet((Iterable)allIds);
        allIds.removeAll(currentUids);
        allIds.forEach(cancelPermissionUid -> {
            this.powerJobPermissionService.retrieveRole(roleScope, target, cancelPermissionUid, role);
            log.info("[WebAuthService] [diffGrant] cancelPermission: roleScope={},target={},uid={},role={}", new Object[]{roleScope, target, cancelPermissionUid, role});
        });
        allIds2.removeAll(originUids);
        allIds2.forEach(addPermissionUid -> {
            this.powerJobPermissionService.grantRole(roleScope, target, addPermissionUid, role, extra);
            log.info("[WebAuthService] [diffGrant] grantPermission: roleScope={},target={},uid={},role={},extra={}", new Object[]{roleScope, target, addPermissionUid, role, extra});
        });
    }
}

