/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.plugin;

import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.interceptor.DynamicPermissionPlugin;

public class ModifyOrCreateDynamicPermission
implements DynamicPermissionPlugin {
    private static final Logger log = LoggerFactory.getLogger(ModifyOrCreateDynamicPermission.class);

    public Permission calculate(HttpServletRequest request, Object handler) {
        try {
            byte[] bodyBytes = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
            String body = new String(bodyBytes, request.getCharacterEncoding());
            Map inputParams = JsonUtils.parseMap((String)body);
            Object id = inputParams.get("id");
            if (id == null) {
                return Permission.NONE;
            }
            return Permission.WRITE;
        }
        catch (Exception e) {
            log.error("[ModifyOrCreateDynamicPermission] check permission failed, please fix the bug!!!", (Throwable)e);
            return Permission.NONE;
        }
    }
}

