/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.service.impl;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.auth.common.AuthErrorCode;
import tech.powerjob.server.auth.common.PowerJobAuthException;
import tech.powerjob.server.common.utils.DigestUtils;
import tech.powerjob.server.persistence.remote.model.PwjbUserInfoDO;
import tech.powerjob.server.persistence.remote.repository.PwjbUserInfoRepository;
import tech.powerjob.server.web.request.ChangePasswordRequest;
import tech.powerjob.server.web.request.ModifyUserInfoRequest;
import tech.powerjob.server.web.service.PwjbUserWebService;

@Service
public class PwjbUserWebServiceImplImpl
implements PwjbUserWebService {
    @Resource
    private PwjbUserInfoRepository pwjbUserInfoRepository;
    private static final Set<String> NOT_ALLOWED_CHANGE_PASSWORD_ACCOUNTS = Sets.newHashSet((Object[])new String[]{"powerjob_trial_account"});

    @Override
    public PwjbUserInfoDO save(ModifyUserInfoRequest request) {
        String username = request.getUsername();
        CommonUtils.requireNonNull((Object)username, (String)"userName can't be null or empty!");
        CommonUtils.requireNonNull((Object)request.getPassword(), (String)"password can't be null or empty!");
        Optional oldUserOpt = this.pwjbUserInfoRepository.findByUsername(username);
        if (oldUserOpt.isPresent()) {
            throw new IllegalArgumentException("username already exist, please change one!");
        }
        PwjbUserInfoDO pwjbUserInfoDO = new PwjbUserInfoDO();
        pwjbUserInfoDO.setUsername(username);
        pwjbUserInfoDO.setGmtCreate(new Date());
        pwjbUserInfoDO.setGmtModified(new Date());
        String password = request.getPassword();
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            pwjbUserInfoDO.setPassword(DigestUtils.rePassword((String)password, (String)pwjbUserInfoDO.getUsername()));
        }
        ModifyUserInfoRequest cpRequest = (ModifyUserInfoRequest)JsonUtils.parseObject((String)JsonUtils.toJSONString((Object)request), ModifyUserInfoRequest.class);
        cpRequest.setPassword(null);
        cpRequest.setUsername(null);
        cpRequest.setNick(null);
        pwjbUserInfoDO.setExtra(JsonUtils.toJSONString((Object)cpRequest));
        return (PwjbUserInfoDO)this.pwjbUserInfoRepository.save((Object)pwjbUserInfoDO);
    }

    @Override
    public void changePassword(ChangePasswordRequest changePasswordRequest) {
        String oldPasswordInReq;
        if (!StringUtils.equals((CharSequence)changePasswordRequest.getNewPassword(), (CharSequence)changePasswordRequest.getNewPassword2())) {
            throw new IllegalArgumentException("Inconsistent passwords");
        }
        String username = changePasswordRequest.getUsername();
        Optional userOpt = this.pwjbUserInfoRepository.findByUsername(username);
        if (!userOpt.isPresent()) {
            throw new IllegalArgumentException("can't find user by username: " + username);
        }
        PwjbUserInfoDO dbUser = (PwjbUserInfoDO)userOpt.get();
        String oldPasswordInDb = dbUser.getPassword();
        if (!StringUtils.equals((CharSequence)oldPasswordInDb, (CharSequence)(oldPasswordInReq = DigestUtils.rePassword((String)changePasswordRequest.getOldPassword(), (String)dbUser.getUsername())))) {
            throw new PowerJobAuthException(AuthErrorCode.INCORRECT_PASSWORD);
        }
        if (NOT_ALLOWED_CHANGE_PASSWORD_ACCOUNTS.contains(username)) {
            throw new IllegalArgumentException("this account not allowed change the password");
        }
        dbUser.setPassword(DigestUtils.rePassword((String)changePasswordRequest.getNewPassword(), (String)dbUser.getUsername()));
        dbUser.setGmtModified(new Date());
        this.pwjbUserInfoRepository.saveAndFlush((Object)dbUser);
    }
}

