/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.service.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.auth.LoginUserHolder;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.service.WebAuthService;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.persistence.QueryConvertUtils;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.model.NamespaceDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.persistence.remote.repository.NamespaceRepository;
import tech.powerjob.server.web.request.ModifyNamespaceRequest;
import tech.powerjob.server.web.request.QueryNamespaceRequest;
import tech.powerjob.server.web.service.NamespaceWebService;

@Service
public class NamespaceWebServiceImpl
implements NamespaceWebService {
    @Resource
    private WebAuthService webAuthService;
    @Resource
    private AppInfoRepository appInfoRepository;
    @Resource
    private NamespaceRepository namespaceRepository;

    @Override
    public NamespaceDO save(ModifyNamespaceRequest req) {
        NamespaceDO namespaceDO;
        boolean isCreate;
        req.valid();
        Long id = req.getId();
        boolean bl = isCreate = id == null;
        if (isCreate) {
            namespaceDO = new NamespaceDO();
            namespaceDO.setGmtCreate(new Date());
            namespaceDO.setCode(req.getCode());
            namespaceDO.setToken(UUID.randomUUID().toString());
            namespaceDO.setCreator(LoginUserHolder.getUserId());
        } else {
            namespaceDO = this.fetchById(id);
            namespaceDO.setModifier(LoginUserHolder.getUserId());
            if (!namespaceDO.getCode().equalsIgnoreCase(req.getCode())) {
                throw new IllegalArgumentException("NOT_ALLOW_CHANGE_THE_NAMESPACE_CODE");
            }
        }
        namespaceDO.setTags(req.getTags());
        namespaceDO.setName(req.getName());
        namespaceDO.setExtra(req.getExtra());
        namespaceDO.setStatus(Optional.ofNullable(req.getStatus()).orElse(SwitchableStatus.ENABLE.getV()));
        namespaceDO.setGmtModified(new Date());
        NamespaceDO savedNamespace = (NamespaceDO)this.namespaceRepository.save((Object)namespaceDO);
        this.webAuthService.processPermissionOnSave(RoleScope.NAMESPACE, savedNamespace.getId(), req.getComponentUserRoleInfo());
        return savedNamespace;
    }

    @Override
    public void delete(Long id) {
        List appInfosInNamespace = this.appInfoRepository.findAllByNamespaceId(id);
        if (CollectionUtils.isNotEmpty((Collection)appInfosInNamespace)) {
            List relatedApps = appInfosInNamespace.stream().map(AppInfoDO::getAppName).collect(Collectors.toList());
            throw new PowerJobException("Unable to delete due to associated apps: " + SJ.COMMA_JOINER.join(relatedApps));
        }
        this.namespaceRepository.deleteById((Object)id);
    }

    @Override
    public Optional<NamespaceDO> findById(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        return this.namespaceRepository.findById((Object)id);
    }

    @Override
    public Page<NamespaceDO> list(QueryNamespaceRequest queryNamespaceRequest) {
        String codeLike = queryNamespaceRequest.getCodeLike();
        String nameLike = queryNamespaceRequest.getNameLike();
        String tagLike = queryNamespaceRequest.getTagLike();
        PageRequest pageable = PageRequest.of((int)queryNamespaceRequest.getIndex(), (int)queryNamespaceRequest.getPageSize());
        Specification & Serializable specification = (Specification & Serializable)(root, query, cb) -> {
            ArrayList predicates = Lists.newArrayList();
            if (StringUtils.isNotEmpty((CharSequence)codeLike)) {
                predicates.add(cb.like((Expression)root.get("code"), QueryConvertUtils.convertLikeParams((Object)codeLike)));
            }
            if (StringUtils.isNotEmpty((CharSequence)nameLike)) {
                predicates.add(cb.like((Expression)root.get("name"), QueryConvertUtils.convertLikeParams((Object)nameLike)));
            }
            if (StringUtils.isNotEmpty((CharSequence)tagLike)) {
                predicates.add(cb.like((Expression)root.get("tags"), QueryConvertUtils.convertLikeParams((Object)tagLike)));
            }
            if (predicates.isEmpty()) {
                return null;
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
        return this.namespaceRepository.findAll((Specification)specification, (Pageable)pageable);
    }

    @Override
    public List<NamespaceDO> listAll() {
        return this.namespaceRepository.findAll();
    }

    private NamespaceDO fetchById(Long id) {
        Optional namespaceDoOpt = this.namespaceRepository.findById((Object)id);
        if (!namespaceDoOpt.isPresent()) {
            throw new IllegalArgumentException("can't find namespace by id: " + id);
        }
        return (NamespaceDO)namespaceDoOpt.get();
    }
}

