/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.server.common.utils.TestUtils;
import tech.powerjob.server.core.alarm.AlarmCenter;
import tech.powerjob.server.core.alarm.module.JobInstanceAlarm;
import tech.powerjob.server.extension.alarm.Alarm;
import tech.powerjob.server.extension.alarm.AlarmTarget;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Value(value="${server.port}")
    private int port;
    @Resource
    private AlarmCenter alarmCenter;

    @RequestMapping(value={"/io"})
    public Map<String, Object> io(@RequestBody Map<String, Object> input) {
        log.info("[TestController] input: {}", (Object)JsonUtils.toJSONString(input));
        return input;
    }

    @GetMapping(value={"/check"})
    public void check() {
        Map testConfig = TestUtils.fetchTestConfig();
        if (CollectionUtils.isEmpty((Map)testConfig)) {
            log.info("[TestController] testConfig not exist, skip check!");
            return;
        }
        log.info("[TestController] testConfig: {}", (Object)JsonUtils.toJSONString((Object)testConfig));
        this.testAlarmCenter();
    }

    void testAlarmCenter() {
        JobInstanceAlarm jobInstanceAlarm = new JobInstanceAlarm().setAppId(277L).setJobId(1L).setInstanceId(2L).setJobName("test-alarm").setJobParams("jobParams").setInstanceParams("instanceParams").setExecuteType(Integer.valueOf(1)).setFinishedTime(Long.valueOf(System.currentTimeMillis()));
        AlarmTarget target = new AlarmTarget().setName("ald").setPhone("208140").setExtra("extra").setPhone(MapUtils.getString((Map)TestUtils.fetchTestConfig(), (Object)"phone")).setEmail("tjq@zju.edu.cn").setWebHook(this.localUrlPath().concat("/test/io"));
        log.info("[TestController] start to testAlarmCenter, target: {}", (Object)target);
        this.alarmCenter.alarmFailed((Alarm)jobInstanceAlarm, (List)Lists.newArrayList((Object[])new AlarmTarget[]{target}));
    }

    private String localUrlPath() {
        return String.format("http://127.0.0.1:%d", this.port);
    }
}

