/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.remote.server.self.ServerInfoService;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;
import tech.powerjob.server.web.response.SystemOverviewVO;
import tech.powerjob.server.web.response.WorkerStatusVO;

@RestController
@RequestMapping(value={"/system"})
public class SystemInfoController {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoController.class);
    private final AppInfoRepository appInfoRepository;
    private final JobInfoRepository jobInfoRepository;
    private final InstanceInfoRepository instanceInfoRepository;
    private final ServerInfoService serverInfoService;
    private final WorkerClusterQueryService workerClusterQueryService;

    @GetMapping(value={"/listWorker"})
    public ResultDTO<List<WorkerStatusVO>> listWorker(Long appId) {
        List workerInfos = this.workerClusterQueryService.getAllWorkers(appId);
        return ResultDTO.success(workerInfos.stream().map(WorkerStatusVO::new).collect(Collectors.toList()));
    }

    @GetMapping(value={"/overview"})
    public ResultDTO<SystemOverviewVO> getSystemOverview(Long appId) {
        SystemOverviewVO overview = new SystemOverviewVO();
        Optional appInfoOpt = this.appInfoRepository.findById((Object)appId);
        if (appInfoOpt.isPresent()) {
            AppInfoDO appInfo = (AppInfoDO)appInfoOpt.get();
            overview.setAppId(appId);
            overview.setAppName(appInfo.getAppName());
        }
        overview.setJobCount(this.jobInfoRepository.countByAppIdAndStatusNot(appId.longValue(), SwitchableStatus.DELETED.getV()));
        overview.setRunningInstanceCount(this.instanceInfoRepository.countByAppIdAndStatus(appId.longValue(), InstanceStatus.RUNNING.getV()));
        Date date = DateUtils.addDays((Date)new Date(), (int)-1);
        overview.setFailedInstanceCount(this.instanceInfoRepository.countByAppIdAndStatusAndGmtCreateAfter(appId.longValue(), InstanceStatus.FAILED.getV(), date));
        overview.setTimezone(TimeZone.getDefault().getDisplayName());
        overview.setServerTime(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        overview.setWebServerInfo(this.serverInfoService.fetchCurrentServerInfo());
        overview.setScheduleServerInfo(this.serverInfoService.fetchAppServerInfo(appId));
        return ResultDTO.success((Object)overview);
    }

    public SystemInfoController(AppInfoRepository appInfoRepository, JobInfoRepository jobInfoRepository, InstanceInfoRepository instanceInfoRepository, ServerInfoService serverInfoService, WorkerClusterQueryService workerClusterQueryService) {
        this.appInfoRepository = appInfoRepository;
        this.jobInfoRepository = jobInfoRepository;
        this.instanceInfoRepository = instanceInfoRepository;
        this.serverInfoService = serverInfoService;
        this.workerClusterQueryService = workerClusterQueryService;
    }
}

