/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.request.http.SaveJobInfoRequest;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.core.service.JobService;
import tech.powerjob.server.persistence.PageResult;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.web.request.QueryJobInfoRequest;
import tech.powerjob.server.web.response.JobInfoVO;

@RestController
@RequestMapping(value={"/job"})
public class JobController {
    private static final Logger log = LoggerFactory.getLogger(JobController.class);
    @Resource
    private JobService jobService;
    @Resource
    private JobInfoRepository jobInfoRepository;

    @PostMapping(value={"/save"})
    @ApiPermission(name="Job-Save", roleScope=RoleScope.APP, requiredPermission=Permission.WRITE)
    public ResultDTO<Void> saveJobInfo(@RequestBody SaveJobInfoRequest request) {
        this.jobService.saveJob(request);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/copy"})
    @ApiPermission(name="Job-Copy", roleScope=RoleScope.APP, requiredPermission=Permission.WRITE)
    public ResultDTO<JobInfoVO> copyJob(String jobId) {
        return ResultDTO.success((Object)JobInfoVO.from(this.jobService.copyJob(Long.valueOf(jobId))));
    }

    @GetMapping(value={"/export"})
    @ApiPermission(name="Job-Export", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public ResultDTO<SaveJobInfoRequest> exportJob(String jobId) {
        return ResultDTO.success((Object)this.jobService.exportJob(Long.valueOf(jobId)));
    }

    @GetMapping(value={"/disable"})
    @ApiPermission(name="Job-Disable", roleScope=RoleScope.APP, requiredPermission=Permission.WRITE)
    public ResultDTO<Void> disableJob(String jobId) {
        this.jobService.disableJob(Long.valueOf(jobId));
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/delete"})
    @ApiPermission(name="Job-Delete", roleScope=RoleScope.APP, requiredPermission=Permission.WRITE)
    public ResultDTO<Void> deleteJob(String jobId) {
        this.jobService.deleteJob(Long.valueOf(jobId));
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/run"})
    @ApiPermission(name="Job-Copy", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<Long> runImmediately(String appId, String jobId, @RequestParam(required=false) String instanceParams) {
        return ResultDTO.success((Object)this.jobService.runJob(Long.valueOf(appId), Long.valueOf(jobId), instanceParams, Long.valueOf(0L)));
    }

    @PostMapping(value={"/list"})
    @ApiPermission(name="Job-Copy", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public ResultDTO<PageResult<JobInfoVO>> listJobs(@RequestBody QueryJobInfoRequest request) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id"});
        PageRequest pageRequest = PageRequest.of((int)request.getIndex(), (int)request.getPageSize(), (Sort)sort);
        if (request.getJobId() == null && StringUtils.isEmpty((CharSequence)request.getKeyword())) {
            Page jobInfoPage = this.jobInfoRepository.findByAppIdAndStatusNot(request.getAppId(), SwitchableStatus.DELETED.getV(), (Pageable)pageRequest);
            return ResultDTO.success(JobController.convertPage((Page<JobInfoDO>)jobInfoPage));
        }
        if (request.getJobId() != null) {
            Optional jobInfoOpt = this.jobInfoRepository.findById((Object)request.getJobId());
            PageResult result = new PageResult();
            if (!jobInfoOpt.isPresent()) {
                result.setTotalPages(0);
                result.setTotalItems(0L);
                result.setData((List)Lists.newLinkedList());
                return ResultDTO.success((Object)result);
            }
            if (!((JobInfoDO)jobInfoOpt.get()).getAppId().equals(request.getAppId())) {
                return ResultDTO.failed((String)"\u8bf7\u8f93\u5165\u8be5app\u4e0b\u7684jobId");
            }
            result.setIndex(0);
            result.setPageSize(request.getPageSize().intValue());
            result.setTotalItems(1L);
            result.setTotalPages(1);
            result.setData((List)Lists.newArrayList((Object[])new JobInfoVO[]{JobInfoVO.from((JobInfoDO)jobInfoOpt.get())}));
            return ResultDTO.success((Object)result);
        }
        String condition = "%" + request.getKeyword() + "%";
        Page jobInfoPage = this.jobInfoRepository.findByAppIdAndJobNameLikeAndStatusNot(request.getAppId(), condition, SwitchableStatus.DELETED.getV(), (Pageable)pageRequest);
        return ResultDTO.success(JobController.convertPage((Page<JobInfoDO>)jobInfoPage));
    }

    private static PageResult<JobInfoVO> convertPage(Page<JobInfoDO> jobInfoPage) {
        List jobInfoVOList = jobInfoPage.getContent().stream().map(JobInfoVO::from).collect(Collectors.toList());
        PageResult pageResult = new PageResult(jobInfoPage);
        pageResult.setData(jobInfoVOList);
        return pageResult;
    }
}

