/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.common.constants.ContainerSourceType;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.common.utils.OmsFileUtils;
import tech.powerjob.server.core.container.ContainerService;
import tech.powerjob.server.core.container.ContainerTemplateGenerator;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.model.ContainerInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.persistence.remote.repository.ContainerInfoRepository;
import tech.powerjob.server.web.request.GenerateContainerTemplateRequest;
import tech.powerjob.server.web.request.SaveContainerInfoRequest;
import tech.powerjob.server.web.response.ContainerInfoVO;

@RestController
@RequestMapping(value={"/container"})
public class ContainerController {
    private static final Logger log = LoggerFactory.getLogger(ContainerController.class);
    private final ContainerService containerService;
    private final AppInfoRepository appInfoRepository;
    private final ContainerInfoRepository containerInfoRepository;

    public ContainerController(ContainerService containerService, AppInfoRepository appInfoRepository, ContainerInfoRepository containerInfoRepository) {
        this.containerService = containerService;
        this.appInfoRepository = appInfoRepository;
        this.containerInfoRepository = containerInfoRepository;
    }

    @GetMapping(value={"/downloadJar"})
    public void downloadJar(String version, HttpServletResponse response) throws IOException {
        File file = this.containerService.fetchContainerJarFile(version);
        if (file.exists()) {
            OmsFileUtils.file2HttpResponse((File)file, (HttpServletResponse)response);
        } else {
            log.error("[Container] can't find container by version[{}], please deploy first!", (Object)version);
        }
    }

    @PostMapping(value={"/downloadContainerTemplate"})
    @ApiPermission(name="Container-DownloadContainerTemplate", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public void downloadContainerTemplate(@RequestBody GenerateContainerTemplateRequest req, HttpServletResponse response) throws IOException {
        File zipFile = ContainerTemplateGenerator.generate((String)req.getGroup(), (String)req.getArtifact(), (String)req.getName(), (String)req.getPackageName(), (Integer)req.getJavaVersion());
        OmsFileUtils.file2HttpResponse((File)zipFile, (HttpServletResponse)response);
    }

    @PostMapping(value={"/jarUpload"})
    @ApiPermission(name="Container-JarUpload", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<String> fileUpload(@RequestParam(value="file") MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            return ResultDTO.failed((String)"empty file");
        }
        return ResultDTO.success((Object)this.containerService.uploadContainerJarFile(file));
    }

    @PostMapping(value={"/save"})
    @ApiPermission(name="Container-Save", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<Void> saveContainer(@RequestBody SaveContainerInfoRequest request) {
        request.valid();
        ContainerInfoDO container = new ContainerInfoDO();
        BeanUtils.copyProperties((Object)request, (Object)container);
        container.setSourceType(Integer.valueOf(request.getSourceType().getV()));
        container.setStatus(Integer.valueOf(request.getStatus().getV()));
        this.containerService.save(container);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/delete"})
    @ApiPermission(name="Container-Delete", roleScope=RoleScope.APP, requiredPermission=Permission.OPS)
    public ResultDTO<Void> deleteContainer(Long appId, Long containerId) {
        this.containerService.delete(appId, containerId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/list"})
    @ApiPermission(name="Container-List", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public ResultDTO<List<ContainerInfoVO>> listContainers(Long appId) {
        List res = this.containerInfoRepository.findByAppIdAndStatusNot(appId, Integer.valueOf(SwitchableStatus.DELETED.getV())).stream().map(ContainerController::convert).collect(Collectors.toList());
        return ResultDTO.success(res);
    }

    @GetMapping(value={"/listDeployedWorker"})
    @ApiPermission(name="Container-ListDeployedWorker", roleScope=RoleScope.APP, requiredPermission=Permission.READ)
    public ResultDTO<String> listDeployedWorker(Long appId, Long containerId, HttpServletResponse response) {
        AppInfoDO appInfoDO = (AppInfoDO)this.appInfoRepository.findById((Object)appId).orElseThrow(() -> new IllegalArgumentException("can't find app by id:" + appId));
        String targetServer = appInfoDO.getCurrentServer();
        if (StringUtils.isEmpty((CharSequence)targetServer)) {
            return ResultDTO.failed((String)"No workers have even registered\uff01");
        }
        return ResultDTO.success((Object)this.containerService.fetchDeployedInfo(appId, containerId));
    }

    private static ContainerInfoVO convert(ContainerInfoDO containerInfoDO) {
        ContainerInfoVO vo = new ContainerInfoVO();
        BeanUtils.copyProperties((Object)containerInfoDO, (Object)vo);
        if (containerInfoDO.getLastDeployTime() == null) {
            vo.setLastDeployTime("N/A");
        } else {
            vo.setLastDeployTime(DateFormatUtils.format((Date)containerInfoDO.getLastDeployTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        SwitchableStatus status = SwitchableStatus.of((int)containerInfoDO.getStatus());
        vo.setStatus(status.name());
        ContainerSourceType sourceType = ContainerSourceType.of((int)containerInfoDO.getSourceType());
        vo.setSourceType(sourceType.name());
        return vo;
    }
}

