/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.auth.LoginUserHolder;
import tech.powerjob.server.auth.Permission;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.auth.plugin.ModifyOrCreateDynamicPermission;
import tech.powerjob.server.auth.plugin.SaveAppGrantPermissionPlugin;
import tech.powerjob.server.auth.service.WebAuthService;
import tech.powerjob.server.persistence.PageResult;
import tech.powerjob.server.persistence.QueryConvertUtils;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.model.NamespaceDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.web.converter.NamespaceConverter;
import tech.powerjob.server.web.request.ComponentUserRoleInfo;
import tech.powerjob.server.web.request.ModifyAppInfoRequest;
import tech.powerjob.server.web.request.QueryAppInfoRequest;
import tech.powerjob.server.web.response.AppInfoVO;
import tech.powerjob.server.web.response.NamespaceBaseVO;
import tech.powerjob.server.web.response.UserBaseVO;
import tech.powerjob.server.web.service.NamespaceWebService;
import tech.powerjob.server.web.service.UserWebService;

@RestController
@RequestMapping(value={"/appInfo"})
public class AppInfoController {
    private final WebAuthService webAuthService;
    private final UserWebService userWebService;
    private final AppInfoRepository appInfoRepository;
    private final NamespaceWebService namespaceWebService;

    @PostMapping(value={"/save"})
    @ApiPermission(name="App-Save", roleScope=RoleScope.APP, dynamicPermissionPlugin=ModifyOrCreateDynamicPermission.class, grandPermissionPlugin=SaveAppGrantPermissionPlugin.class)
    public ResultDTO<AppInfoVO> saveAppInfo(@RequestBody ModifyAppInfoRequest req) {
        AppInfoDO appInfoDO;
        req.valid();
        Long id = req.getId();
        if (id == null) {
            appInfoDO = new AppInfoDO();
            appInfoDO.setGmtCreate(new Date());
            appInfoDO.setCreator(LoginUserHolder.getUserId());
        } else {
            appInfoDO = (AppInfoDO)this.appInfoRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("can't find appInfo by id:" + id));
            if (!appInfoDO.getAppName().equalsIgnoreCase(req.getAppName())) {
                throw new IllegalArgumentException("NOT_ALLOW_CHANGE_THE_APP_NAME");
            }
        }
        appInfoDO.setAppName(req.getAppName());
        appInfoDO.setTitle(req.getTitle());
        appInfoDO.setPassword(req.getPassword());
        appInfoDO.setNamespaceId(req.getNamespaceId());
        appInfoDO.setTags(req.getTags());
        appInfoDO.setExtra(req.getExtra());
        appInfoDO.setGmtModified(new Date());
        appInfoDO.setModifier(LoginUserHolder.getUserId());
        AppInfoDO savedAppInfo = (AppInfoDO)this.appInfoRepository.saveAndFlush((Object)appInfoDO);
        this.webAuthService.processPermissionOnSave(RoleScope.APP, savedAppInfo.getId(), req.getComponentUserRoleInfo());
        return ResultDTO.success((Object)this.convert(Lists.newArrayList((Object[])new AppInfoDO[]{savedAppInfo}), false).get(0));
    }

    @GetMapping(value={"/delete"})
    @ApiPermission(name="App-Delete", roleScope=RoleScope.APP, requiredPermission=Permission.SU)
    public ResultDTO<Void> deleteAppInfo(Long appId) {
        this.appInfoRepository.deleteById((Object)appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/list"})
    @ApiPermission(name="Namespace-List", roleScope=RoleScope.APP, requiredPermission=Permission.NONE)
    public ResultDTO<PageResult<AppInfoVO>> listAppInfoByQuery(@RequestBody QueryAppInfoRequest queryAppInfoRequest) {
        HashSet queryAppIds;
        PageRequest pageable = PageRequest.of((int)queryAppInfoRequest.getIndex(), (int)queryAppInfoRequest.getPageSize());
        Boolean showMyRelated = queryAppInfoRequest.getShowMyRelated();
        if (BooleanUtils.isTrue((Boolean)showMyRelated)) {
            HashSet targetIds = Sets.newHashSet();
            this.webAuthService.fetchMyPermissionTargets(RoleScope.APP).values().forEach(targetIds::addAll);
            queryAppIds = targetIds;
        } else {
            queryAppIds = Collections.emptySet();
        }
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList predicates = Lists.newArrayList();
            Long appId = queryAppInfoRequest.getAppId();
            Long namespaceId = queryAppInfoRequest.getNamespaceId();
            if (appId != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)appId));
            }
            if (namespaceId != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("namespaceId"), (Object)namespaceId));
            }
            if (StringUtils.isNotEmpty((CharSequence)queryAppInfoRequest.getAppNameLike())) {
                predicates.add(criteriaBuilder.like((Expression)root.get("appName"), QueryConvertUtils.convertLikeParams((Object)queryAppInfoRequest.getAppNameLike())));
            }
            if (StringUtils.isNotEmpty((CharSequence)queryAppInfoRequest.getTagLike())) {
                predicates.add(criteriaBuilder.like((Expression)root.get("tags"), QueryConvertUtils.convertLikeParams((Object)queryAppInfoRequest.getTagLike())));
            }
            if (!queryAppIds.isEmpty()) {
                predicates.add(criteriaBuilder.in((Expression)root.get("id")).value((Object)queryAppIds));
            }
            return query.where(predicates.toArray(new Predicate[0])).getRestriction();
        };
        Page pageAppInfoResult = this.appInfoRepository.findAll((Specification)specification, (Pageable)pageable);
        PageResult pageRet = new PageResult(pageAppInfoResult);
        List<AppInfoDO> appInfoDos = pageAppInfoResult.get().collect(Collectors.toList());
        pageRet.setData(this.convert(appInfoDos, true));
        return ResultDTO.success((Object)pageRet);
    }

    private List<AppInfoVO> convert(List<AppInfoDO> data, boolean fillDetail) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newLinkedList();
        }
        return data.parallelStream().map(appInfoDO -> {
            AppInfoVO appInfoVO = new AppInfoVO();
            BeanUtils.copyProperties((Object)appInfoDO, (Object)appInfoVO);
            appInfoVO.setGmtCreateStr(CommonUtils.formatTime((Date)appInfoDO.getGmtCreate()));
            appInfoVO.setGmtModifiedStr(CommonUtils.formatTime((Date)appInfoDO.getGmtModified()));
            if (fillDetail) {
                ComponentUserRoleInfo componentUserRoleInfo = this.webAuthService.fetchComponentUserRoleInfo(RoleScope.APP, appInfoDO.getId());
                appInfoVO.setComponentUserRoleInfo(componentUserRoleInfo);
                boolean hasPermission = this.webAuthService.hasPermission(RoleScope.APP, appInfoDO.getId(), Permission.READ);
                appInfoVO.setPassword(hasPermission ? appInfoDO.getPassword() : "NO_PERMISSION_TO_SEE");
                Optional<NamespaceDO> namespaceOpt = this.namespaceWebService.findById(appInfoDO.getNamespaceId());
                if (namespaceOpt.isPresent()) {
                    NamespaceBaseVO baseNamespace = NamespaceConverter.do2BaseVo(namespaceOpt.get());
                    appInfoVO.setNamespace(baseNamespace);
                    appInfoVO.setNamespaceName(baseNamespace.getName());
                }
                appInfoVO.setCreatorShowName(this.userWebService.fetchBaseUserInfo(appInfoDO.getCreator()).map(UserBaseVO::getShowName).orElse(null));
                appInfoVO.setModifierShowName(this.userWebService.fetchBaseUserInfo(appInfoDO.getModifier()).map(UserBaseVO::getShowName).orElse(null));
            }
            return appInfoVO;
        }).collect(Collectors.toList());
    }

    public AppInfoController(WebAuthService webAuthService, UserWebService userWebService, AppInfoRepository appInfoRepository, NamespaceWebService namespaceWebService) {
        this.webAuthService = webAuthService;
        this.userWebService = userWebService;
        this.appInfoRepository = appInfoRepository;
        this.namespaceWebService = namespaceWebService;
    }
}

