/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.initializer;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.Role;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.common.AuthConstants;
import tech.powerjob.server.auth.service.login.LoginRequest;
import tech.powerjob.server.auth.service.login.PowerJobLoginService;
import tech.powerjob.server.auth.service.permission.PowerJobPermissionService;
import tech.powerjob.server.initializer.SystemInitializeService;
import tech.powerjob.server.persistence.remote.model.NamespaceDO;
import tech.powerjob.server.persistence.remote.model.PwjbUserInfoDO;
import tech.powerjob.server.web.request.ModifyNamespaceRequest;
import tech.powerjob.server.web.request.ModifyUserInfoRequest;
import tech.powerjob.server.web.service.NamespaceWebService;
import tech.powerjob.server.web.service.PwjbUserWebService;

@Service
public class SystemInitializeServiceImpl
implements SystemInitializeService {
    private static final Logger log = LoggerFactory.getLogger(SystemInitializeServiceImpl.class);
    @Value(value="${oms.auth.initiliaze.admin.password:#{null}}")
    private String defaultAdminPassword;
    @Resource
    private PwjbUserWebService pwjbUserWebService;
    @Resource
    private NamespaceWebService namespaceWebService;
    @Resource
    private PowerJobLoginService powerJobLoginService;
    @Resource
    private PowerJobPermissionService powerJobPermissionService;
    private static final String SYSTEM_ADMIN_NAME = "ADMIN";
    private static final String SYSTEM_DEFAULT_NAMESPACE = "default_namespace";

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void initAdmin() {
        String username = SYSTEM_ADMIN_NAME;
        String password = StringUtils.isEmpty((CharSequence)this.defaultAdminPassword) ? RandomStringUtils.randomAlphabetic((int)8) : this.defaultAdminPassword;
        ModifyUserInfoRequest createUser = new ModifyUserInfoRequest();
        createUser.setUsername(username);
        createUser.setNick(username);
        createUser.setPassword(password);
        log.info("[SystemInitializeService] [S1] create default PWJB user by request: {}", (Object)createUser);
        PwjbUserInfoDO savedPwjbUser = this.pwjbUserWebService.save(createUser);
        log.info("[SystemInitializeService] [S1] create default PWJB user successfully: {}", (Object)savedPwjbUser);
        HashMap params = Maps.newHashMap();
        params.put("username", username);
        params.put("password", password);
        LoginRequest loginRequest = new LoginRequest().setLoginType("PWJB").setOriginParams(JsonUtils.toJSONString((Object)params));
        log.info("[SystemInitializeService] [S2] createPowerJobUser user by request: {}", (Object)loginRequest);
        PowerJobUser powerJobUser = this.powerJobLoginService.doLogin(loginRequest);
        log.info("[SystemInitializeService] [S2] createPowerJobUser successfully: {}", (Object)powerJobUser);
        this.powerJobPermissionService.grantRole(RoleScope.GLOBAL, AuthConstants.GLOBAL_ADMIN_TARGET_ID, powerJobUser.getId(), Role.ADMIN, null);
        log.info("[SystemInitializeService] [S3] GRANT ADMIN successfully!");
        for (int i = 0; i < 10; ++i) {
            log.warn("[SystemInitializeService] The system has automatically created a super administrator account[username={},password={}], please log in and change the password immediately!", (Object)username, (Object)password);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void initNamespace() {
        ModifyNamespaceRequest saveNamespaceReq = new ModifyNamespaceRequest();
        saveNamespaceReq.setName(SYSTEM_DEFAULT_NAMESPACE);
        saveNamespaceReq.setCode(SYSTEM_DEFAULT_NAMESPACE);
        log.info("[SystemInitializeService] create default namespace by request: {}", (Object)saveNamespaceReq);
        NamespaceDO savedNamespaceDO = this.namespaceWebService.save(saveNamespaceReq);
        log.info("[SystemInitializeService] create default namespace successfully: {}", (Object)savedNamespaceDO);
    }
}

