/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.config;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.stereotype.Component;

@Component
public class CachingRequestBodyFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            CustomHttpServletRequestWrapper wrappedRequest = new CustomHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)wrappedRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public static class CustomHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final String body;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CustomHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader bufferedReader = null;){
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                    char[] charBuffer = new char[128];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                }
            }
            this.body = stringBuilder.toString();
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
            return new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                public boolean isFinished() {
                    return byteArrayInputStream.available() == 0;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public String getBody() {
            return this.body;
        }
    }
}

