/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.plugin;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.auth.LoginUserHolder;
import tech.powerjob.server.auth.PowerJobUser;
import tech.powerjob.server.auth.Role;
import tech.powerjob.server.auth.RoleScope;
import tech.powerjob.server.auth.interceptor.GrantPermissionPlugin;
import tech.powerjob.server.auth.service.permission.PowerJobPermissionService;
import tech.powerjob.server.common.utils.SpringUtils;

public abstract class SaveGrantPermissionPlugin
implements GrantPermissionPlugin {
    private static final Logger log = LoggerFactory.getLogger(SaveGrantPermissionPlugin.class);
    private static final String KEY_ID = "id";

    public void grant(Object[] args, Object result, Method method, Object originBean) {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("[GrantPermission] args not match, maybe there has some bug");
        }
        PowerJobUser powerJobUser = LoginUserHolder.get();
        if (powerJobUser == null) {
            throw new IllegalArgumentException("[GrantPermission] user not login, can't grant permission");
        }
        Map saveRequest = JsonUtils.parseMap((String)JsonUtils.toJSONString((Object)args[0]));
        Long id = MapUtils.getLong((Map)saveRequest, (Object)KEY_ID);
        if (id != null) {
            return;
        }
        if (!(result instanceof ResultDTO)) {
            throw new IllegalArgumentException("[GrantPermission] result not instanceof ResultDTO, maybe there has some bug");
        }
        ResultDTO resultDTO = (ResultDTO)result;
        if (!resultDTO.isSuccess()) {
            log.warn("[GrantPermission] result not success, skip grant permission!");
            return;
        }
        Map saveResult = JsonUtils.parseMap((String)JsonUtils.toJSONString((Object)resultDTO.getData()));
        Long savedId = MapUtils.getLong((Map)saveResult, (Object)KEY_ID);
        if (savedId == null) {
            throw new IllegalArgumentException("[GrantPermission] result success but id not exits, maybe there has some bug, please fix it!!!");
        }
        PowerJobPermissionService powerJobPermissionService = (PowerJobPermissionService)SpringUtils.getBean(PowerJobPermissionService.class);
        HashMap extra = Maps.newHashMap();
        extra.put("source", "SaveGrantPermissionPlugin");
        powerJobPermissionService.grantRole(this.fetchRuleScope(), savedId, powerJobUser.getId(), Role.ADMIN, JsonUtils.toJSONString((Object)extra));
    }

    protected abstract RoleScope fetchRuleScope();
}

