/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.response;

import java.text.DecimalFormat;
import tech.powerjob.common.model.SystemMetrics;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.common.module.WorkerInfo;

public class WorkerStatusVO {
    private String address;
    private String cpuLoad;
    private String memoryLoad;
    private String diskLoad;
    private String protocol;
    private String tag;
    private String lastActiveTime;
    private Integer lightTaskTrackerNum;
    private Integer heavyTaskTrackerNum;
    private long lastOverloadTime;
    private boolean overloading;
    private int status;
    private static final String CPU_FORMAT = "%s / %s cores";
    private static final String OTHER_FORMAT = "%s%%\uff08%s / %s GB\uff09";
    private static final DecimalFormat df = new DecimalFormat("#.#");
    private static final double THRESHOLD = 0.8;

    public WorkerStatusVO(WorkerInfo workerInfo) {
        SystemMetrics systemMetrics = workerInfo.getSystemMetrics();
        this.status = 1;
        this.address = workerInfo.getAddress();
        this.cpuLoad = String.format(CPU_FORMAT, df.format(systemMetrics.getCpuLoad()), systemMetrics.getCpuProcessors());
        if (systemMetrics.getCpuLoad() > (double)systemMetrics.getCpuProcessors() * 0.8) {
            ++this.status;
        }
        String menL = df.format(systemMetrics.getJvmMemoryUsage() * 100.0);
        String menUsed = df.format(systemMetrics.getJvmUsedMemory());
        String menMax = df.format(systemMetrics.getJvmMaxMemory());
        this.memoryLoad = String.format(OTHER_FORMAT, menL, menUsed, menMax);
        if (systemMetrics.getJvmMemoryUsage() > 0.8) {
            ++this.status;
        }
        String diskL = df.format(systemMetrics.getDiskUsage() * 100.0);
        String diskUsed = df.format(systemMetrics.getDiskUsed());
        String diskMax = df.format(systemMetrics.getDiskTotal());
        this.diskLoad = String.format(OTHER_FORMAT, diskL, diskUsed, diskMax);
        if (systemMetrics.getDiskUsage() > 0.8) {
            ++this.status;
        }
        if (workerInfo.overload()) {
            this.status = 3;
        }
        if (workerInfo.timeout()) {
            this.status = 9999;
        }
        this.protocol = workerInfo.getProtocol();
        this.tag = CommonUtils.formatString((String)workerInfo.getTag());
        this.lastActiveTime = CommonUtils.formatTime((Long)workerInfo.getLastActiveTime());
        this.lightTaskTrackerNum = workerInfo.getLightTaskTrackerNum();
        this.heavyTaskTrackerNum = workerInfo.getHeavyTaskTrackerNum();
        this.lastOverloadTime = workerInfo.getLastOverloadTime();
        this.overloading = workerInfo.isOverloading();
    }

    public String getAddress() {
        return this.address;
    }

    public String getCpuLoad() {
        return this.cpuLoad;
    }

    public String getMemoryLoad() {
        return this.memoryLoad;
    }

    public String getDiskLoad() {
        return this.diskLoad;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getTag() {
        return this.tag;
    }

    public String getLastActiveTime() {
        return this.lastActiveTime;
    }

    public Integer getLightTaskTrackerNum() {
        return this.lightTaskTrackerNum;
    }

    public Integer getHeavyTaskTrackerNum() {
        return this.heavyTaskTrackerNum;
    }

    public long getLastOverloadTime() {
        return this.lastOverloadTime;
    }

    public boolean isOverloading() {
        return this.overloading;
    }

    public int getStatus() {
        return this.status;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCpuLoad(String cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public void setMemoryLoad(String memoryLoad) {
        this.memoryLoad = memoryLoad;
    }

    public void setDiskLoad(String diskLoad) {
        this.diskLoad = diskLoad;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setLastActiveTime(String lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public void setLightTaskTrackerNum(Integer lightTaskTrackerNum) {
        this.lightTaskTrackerNum = lightTaskTrackerNum;
    }

    public void setHeavyTaskTrackerNum(Integer heavyTaskTrackerNum) {
        this.heavyTaskTrackerNum = heavyTaskTrackerNum;
    }

    public void setLastOverloadTime(long lastOverloadTime) {
        this.lastOverloadTime = lastOverloadTime;
    }

    public void setOverloading(boolean overloading) {
        this.overloading = overloading;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerStatusVO)) {
            return false;
        }
        WorkerStatusVO other = (WorkerStatusVO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$cpuLoad = this.getCpuLoad();
        String other$cpuLoad = other.getCpuLoad();
        if (this$cpuLoad == null ? other$cpuLoad != null : !this$cpuLoad.equals(other$cpuLoad)) {
            return false;
        }
        String this$memoryLoad = this.getMemoryLoad();
        String other$memoryLoad = other.getMemoryLoad();
        if (this$memoryLoad == null ? other$memoryLoad != null : !this$memoryLoad.equals(other$memoryLoad)) {
            return false;
        }
        String this$diskLoad = this.getDiskLoad();
        String other$diskLoad = other.getDiskLoad();
        if (this$diskLoad == null ? other$diskLoad != null : !this$diskLoad.equals(other$diskLoad)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$lastActiveTime = this.getLastActiveTime();
        String other$lastActiveTime = other.getLastActiveTime();
        if (this$lastActiveTime == null ? other$lastActiveTime != null : !this$lastActiveTime.equals(other$lastActiveTime)) {
            return false;
        }
        Integer this$lightTaskTrackerNum = this.getLightTaskTrackerNum();
        Integer other$lightTaskTrackerNum = other.getLightTaskTrackerNum();
        if (this$lightTaskTrackerNum == null ? other$lightTaskTrackerNum != null : !((Object)this$lightTaskTrackerNum).equals(other$lightTaskTrackerNum)) {
            return false;
        }
        Integer this$heavyTaskTrackerNum = this.getHeavyTaskTrackerNum();
        Integer other$heavyTaskTrackerNum = other.getHeavyTaskTrackerNum();
        if (this$heavyTaskTrackerNum == null ? other$heavyTaskTrackerNum != null : !((Object)this$heavyTaskTrackerNum).equals(other$heavyTaskTrackerNum)) {
            return false;
        }
        if (this.getLastOverloadTime() != other.getLastOverloadTime()) {
            return false;
        }
        if (this.isOverloading() != other.isOverloading()) {
            return false;
        }
        return this.getStatus() == other.getStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerStatusVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $cpuLoad = this.getCpuLoad();
        result = result * 59 + ($cpuLoad == null ? 43 : $cpuLoad.hashCode());
        String $memoryLoad = this.getMemoryLoad();
        result = result * 59 + ($memoryLoad == null ? 43 : $memoryLoad.hashCode());
        String $diskLoad = this.getDiskLoad();
        result = result * 59 + ($diskLoad == null ? 43 : $diskLoad.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $lastActiveTime = this.getLastActiveTime();
        result = result * 59 + ($lastActiveTime == null ? 43 : $lastActiveTime.hashCode());
        Integer $lightTaskTrackerNum = this.getLightTaskTrackerNum();
        result = result * 59 + ($lightTaskTrackerNum == null ? 43 : ((Object)$lightTaskTrackerNum).hashCode());
        Integer $heavyTaskTrackerNum = this.getHeavyTaskTrackerNum();
        result = result * 59 + ($heavyTaskTrackerNum == null ? 43 : ((Object)$heavyTaskTrackerNum).hashCode());
        long $lastOverloadTime = this.getLastOverloadTime();
        result = result * 59 + (int)($lastOverloadTime >>> 32 ^ $lastOverloadTime);
        result = result * 59 + (this.isOverloading() ? 79 : 97);
        result = result * 59 + this.getStatus();
        return result;
    }

    public String toString() {
        return "WorkerStatusVO(address=" + this.getAddress() + ", cpuLoad=" + this.getCpuLoad() + ", memoryLoad=" + this.getMemoryLoad() + ", diskLoad=" + this.getDiskLoad() + ", protocol=" + this.getProtocol() + ", tag=" + this.getTag() + ", lastActiveTime=" + this.getLastActiveTime() + ", lightTaskTrackerNum=" + this.getLightTaskTrackerNum() + ", heavyTaskTrackerNum=" + this.getHeavyTaskTrackerNum() + ", lastOverloadTime=" + this.getLastOverloadTime() + ", overloading=" + this.isOverloading() + ", status=" + this.getStatus() + ")";
    }

    public WorkerStatusVO() {
    }
}

