/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.response;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;

public class WorkflowInstanceInfoVO {
    private String wfInstanceId;
    private String workflowId;
    private String workflowName;
    private Integer status;
    private String wfInitParams;
    private String wfContext;
    private PEWorkflowDAG pEWorkflowDAG;
    private String result;
    private String expectedTriggerTime;
    private String actualTriggerTime;
    private String finishedTime;

    public static WorkflowInstanceInfoVO from(WorkflowInstanceInfoDO wfInstanceDO, String workflowName) {
        WorkflowInstanceInfoVO vo = new WorkflowInstanceInfoVO();
        BeanUtils.copyProperties((Object)wfInstanceDO, (Object)vo);
        vo.setWorkflowName(workflowName);
        vo.setPEWorkflowDAG((PEWorkflowDAG)JSONObject.parseObject((String)wfInstanceDO.getDag(), PEWorkflowDAG.class));
        vo.setWfInstanceId(String.valueOf(wfInstanceDO.getWfInstanceId()));
        vo.setWorkflowId(String.valueOf(wfInstanceDO.getWorkflowId()));
        if (wfInstanceDO.getExpectedTriggerTime() != null) {
            vo.setExpectedTriggerTime(DateFormatUtils.format((long)wfInstanceDO.getExpectedTriggerTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        vo.setActualTriggerTime(DateFormatUtils.format((long)wfInstanceDO.getActualTriggerTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (wfInstanceDO.getFinishedTime() == null) {
            vo.setFinishedTime("N/A");
        } else {
            vo.setFinishedTime(DateFormatUtils.format((long)wfInstanceDO.getFinishedTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return vo;
    }

    public String getWfInstanceId() {
        return this.wfInstanceId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getWfInitParams() {
        return this.wfInitParams;
    }

    public String getWfContext() {
        return this.wfContext;
    }

    public PEWorkflowDAG getPEWorkflowDAG() {
        return this.pEWorkflowDAG;
    }

    public String getResult() {
        return this.result;
    }

    public String getExpectedTriggerTime() {
        return this.expectedTriggerTime;
    }

    public String getActualTriggerTime() {
        return this.actualTriggerTime;
    }

    public String getFinishedTime() {
        return this.finishedTime;
    }

    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setWfInitParams(String wfInitParams) {
        this.wfInitParams = wfInitParams;
    }

    public void setWfContext(String wfContext) {
        this.wfContext = wfContext;
    }

    public void setPEWorkflowDAG(PEWorkflowDAG pEWorkflowDAG) {
        this.pEWorkflowDAG = pEWorkflowDAG;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setExpectedTriggerTime(String expectedTriggerTime) {
        this.expectedTriggerTime = expectedTriggerTime;
    }

    public void setActualTriggerTime(String actualTriggerTime) {
        this.actualTriggerTime = actualTriggerTime;
    }

    public void setFinishedTime(String finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowInstanceInfoVO)) {
            return false;
        }
        WorkflowInstanceInfoVO other = (WorkflowInstanceInfoVO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$wfInstanceId = this.getWfInstanceId();
        String other$wfInstanceId = other.getWfInstanceId();
        if (this$wfInstanceId == null ? other$wfInstanceId != null : !this$wfInstanceId.equals(other$wfInstanceId)) {
            return false;
        }
        String this$workflowId = this.getWorkflowId();
        String other$workflowId = other.getWorkflowId();
        if (this$workflowId == null ? other$workflowId != null : !this$workflowId.equals(other$workflowId)) {
            return false;
        }
        String this$workflowName = this.getWorkflowName();
        String other$workflowName = other.getWorkflowName();
        if (this$workflowName == null ? other$workflowName != null : !this$workflowName.equals(other$workflowName)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$wfInitParams = this.getWfInitParams();
        String other$wfInitParams = other.getWfInitParams();
        if (this$wfInitParams == null ? other$wfInitParams != null : !this$wfInitParams.equals(other$wfInitParams)) {
            return false;
        }
        String this$wfContext = this.getWfContext();
        String other$wfContext = other.getWfContext();
        if (this$wfContext == null ? other$wfContext != null : !this$wfContext.equals(other$wfContext)) {
            return false;
        }
        PEWorkflowDAG this$pEWorkflowDAG = this.getPEWorkflowDAG();
        PEWorkflowDAG other$pEWorkflowDAG = other.getPEWorkflowDAG();
        if (this$pEWorkflowDAG == null ? other$pEWorkflowDAG != null : !this$pEWorkflowDAG.equals(other$pEWorkflowDAG)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$expectedTriggerTime = this.getExpectedTriggerTime();
        String other$expectedTriggerTime = other.getExpectedTriggerTime();
        if (this$expectedTriggerTime == null ? other$expectedTriggerTime != null : !this$expectedTriggerTime.equals(other$expectedTriggerTime)) {
            return false;
        }
        String this$actualTriggerTime = this.getActualTriggerTime();
        String other$actualTriggerTime = other.getActualTriggerTime();
        if (this$actualTriggerTime == null ? other$actualTriggerTime != null : !this$actualTriggerTime.equals(other$actualTriggerTime)) {
            return false;
        }
        String this$finishedTime = this.getFinishedTime();
        String other$finishedTime = other.getFinishedTime();
        return !(this$finishedTime == null ? other$finishedTime != null : !this$finishedTime.equals(other$finishedTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowInstanceInfoVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $wfInstanceId = this.getWfInstanceId();
        result = result * 59 + ($wfInstanceId == null ? 43 : $wfInstanceId.hashCode());
        String $workflowId = this.getWorkflowId();
        result = result * 59 + ($workflowId == null ? 43 : $workflowId.hashCode());
        String $workflowName = this.getWorkflowName();
        result = result * 59 + ($workflowName == null ? 43 : $workflowName.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $wfInitParams = this.getWfInitParams();
        result = result * 59 + ($wfInitParams == null ? 43 : $wfInitParams.hashCode());
        String $wfContext = this.getWfContext();
        result = result * 59 + ($wfContext == null ? 43 : $wfContext.hashCode());
        PEWorkflowDAG $pEWorkflowDAG = this.getPEWorkflowDAG();
        result = result * 59 + ($pEWorkflowDAG == null ? 43 : $pEWorkflowDAG.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $expectedTriggerTime = this.getExpectedTriggerTime();
        result = result * 59 + ($expectedTriggerTime == null ? 43 : $expectedTriggerTime.hashCode());
        String $actualTriggerTime = this.getActualTriggerTime();
        result = result * 59 + ($actualTriggerTime == null ? 43 : $actualTriggerTime.hashCode());
        String $finishedTime = this.getFinishedTime();
        result = result * 59 + ($finishedTime == null ? 43 : $finishedTime.hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowInstanceInfoVO(wfInstanceId=" + this.getWfInstanceId() + ", workflowId=" + this.getWorkflowId() + ", workflowName=" + this.getWorkflowName() + ", status=" + this.getStatus() + ", wfInitParams=" + this.getWfInitParams() + ", wfContext=" + this.getWfContext() + ", pEWorkflowDAG=" + this.getPEWorkflowDAG() + ", result=" + this.getResult() + ", expectedTriggerTime=" + this.getExpectedTriggerTime() + ", actualTriggerTime=" + this.getActualTriggerTime() + ", finishedTime=" + this.getFinishedTime() + ")";
    }
}

