/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.response;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;

public class WorkflowInfoVO {
    private Long id;
    private String wfName;
    private String wfDescription;
    private Long appId;
    private PEWorkflowDAG pEWorkflowDAG;
    private String timeExpressionType;
    private String timeExpression;
    private Integer maxWfInstanceNum;
    private Boolean enable;
    private List<Long> notifyUserIds;
    private LifeCycle lifeCycle;
    private Date gmtCreate;
    private Date gmtModified;

    public static WorkflowInfoVO from(WorkflowInfoDO wfDO) {
        WorkflowInfoVO vo = new WorkflowInfoVO();
        BeanUtils.copyProperties((Object)wfDO, (Object)vo);
        vo.enable = SwitchableStatus.of((int)wfDO.getStatus()) == SwitchableStatus.ENABLE;
        vo.setTimeExpressionType(TimeExpressionType.of((int)wfDO.getTimeExpressionType()).name());
        vo.setPEWorkflowDAG((PEWorkflowDAG)JSON.parseObject((String)wfDO.getPeDAG(), PEWorkflowDAG.class));
        if (!StringUtils.isEmpty((CharSequence)wfDO.getNotifyUserIds())) {
            vo.setNotifyUserIds(SJ.COMMA_SPLITTER.splitToList((CharSequence)wfDO.getNotifyUserIds()).stream().map(Long::valueOf).collect(Collectors.toList()));
        }
        if (!StringUtils.isEmpty((CharSequence)wfDO.getLifecycle())) {
            vo.lifeCycle = LifeCycle.parse((String)wfDO.getLifecycle());
        }
        return vo;
    }

    public Long getId() {
        return this.id;
    }

    public String getWfName() {
        return this.wfName;
    }

    public String getWfDescription() {
        return this.wfDescription;
    }

    public Long getAppId() {
        return this.appId;
    }

    public PEWorkflowDAG getPEWorkflowDAG() {
        return this.pEWorkflowDAG;
    }

    public String getTimeExpressionType() {
        return this.timeExpressionType;
    }

    public String getTimeExpression() {
        return this.timeExpression;
    }

    public Integer getMaxWfInstanceNum() {
        return this.maxWfInstanceNum;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public List<Long> getNotifyUserIds() {
        return this.notifyUserIds;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setWfName(String wfName) {
        this.wfName = wfName;
    }

    public void setWfDescription(String wfDescription) {
        this.wfDescription = wfDescription;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setPEWorkflowDAG(PEWorkflowDAG pEWorkflowDAG) {
        this.pEWorkflowDAG = pEWorkflowDAG;
    }

    public void setTimeExpressionType(String timeExpressionType) {
        this.timeExpressionType = timeExpressionType;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public void setMaxWfInstanceNum(Integer maxWfInstanceNum) {
        this.maxWfInstanceNum = maxWfInstanceNum;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setNotifyUserIds(List<Long> notifyUserIds) {
        this.notifyUserIds = notifyUserIds;
    }

    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowInfoVO)) {
            return false;
        }
        WorkflowInfoVO other = (WorkflowInfoVO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$wfName = this.getWfName();
        String other$wfName = other.getWfName();
        if (this$wfName == null ? other$wfName != null : !this$wfName.equals(other$wfName)) {
            return false;
        }
        String this$wfDescription = this.getWfDescription();
        String other$wfDescription = other.getWfDescription();
        if (this$wfDescription == null ? other$wfDescription != null : !this$wfDescription.equals(other$wfDescription)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        PEWorkflowDAG this$pEWorkflowDAG = this.getPEWorkflowDAG();
        PEWorkflowDAG other$pEWorkflowDAG = other.getPEWorkflowDAG();
        if (this$pEWorkflowDAG == null ? other$pEWorkflowDAG != null : !this$pEWorkflowDAG.equals(other$pEWorkflowDAG)) {
            return false;
        }
        String this$timeExpressionType = this.getTimeExpressionType();
        String other$timeExpressionType = other.getTimeExpressionType();
        if (this$timeExpressionType == null ? other$timeExpressionType != null : !this$timeExpressionType.equals(other$timeExpressionType)) {
            return false;
        }
        String this$timeExpression = this.getTimeExpression();
        String other$timeExpression = other.getTimeExpression();
        if (this$timeExpression == null ? other$timeExpression != null : !this$timeExpression.equals(other$timeExpression)) {
            return false;
        }
        Integer this$maxWfInstanceNum = this.getMaxWfInstanceNum();
        Integer other$maxWfInstanceNum = other.getMaxWfInstanceNum();
        if (this$maxWfInstanceNum == null ? other$maxWfInstanceNum != null : !((Object)this$maxWfInstanceNum).equals(other$maxWfInstanceNum)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        List this$notifyUserIds = this.getNotifyUserIds();
        List other$notifyUserIds = other.getNotifyUserIds();
        if (this$notifyUserIds == null ? other$notifyUserIds != null : !((Object)this$notifyUserIds).equals(other$notifyUserIds)) {
            return false;
        }
        LifeCycle this$lifeCycle = this.getLifeCycle();
        LifeCycle other$lifeCycle = other.getLifeCycle();
        if (this$lifeCycle == null ? other$lifeCycle != null : !this$lifeCycle.equals(other$lifeCycle)) {
            return false;
        }
        Date this$gmtCreate = this.getGmtCreate();
        Date other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Date this$gmtModified = this.getGmtModified();
        Date other$gmtModified = other.getGmtModified();
        return !(this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowInfoVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $wfName = this.getWfName();
        result = result * 59 + ($wfName == null ? 43 : $wfName.hashCode());
        String $wfDescription = this.getWfDescription();
        result = result * 59 + ($wfDescription == null ? 43 : $wfDescription.hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        PEWorkflowDAG $pEWorkflowDAG = this.getPEWorkflowDAG();
        result = result * 59 + ($pEWorkflowDAG == null ? 43 : $pEWorkflowDAG.hashCode());
        String $timeExpressionType = this.getTimeExpressionType();
        result = result * 59 + ($timeExpressionType == null ? 43 : $timeExpressionType.hashCode());
        String $timeExpression = this.getTimeExpression();
        result = result * 59 + ($timeExpression == null ? 43 : $timeExpression.hashCode());
        Integer $maxWfInstanceNum = this.getMaxWfInstanceNum();
        result = result * 59 + ($maxWfInstanceNum == null ? 43 : ((Object)$maxWfInstanceNum).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        List $notifyUserIds = this.getNotifyUserIds();
        result = result * 59 + ($notifyUserIds == null ? 43 : ((Object)$notifyUserIds).hashCode());
        LifeCycle $lifeCycle = this.getLifeCycle();
        result = result * 59 + ($lifeCycle == null ? 43 : $lifeCycle.hashCode());
        Date $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Date $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowInfoVO(id=" + this.getId() + ", wfName=" + this.getWfName() + ", wfDescription=" + this.getWfDescription() + ", appId=" + this.getAppId() + ", pEWorkflowDAG=" + this.getPEWorkflowDAG() + ", timeExpressionType=" + this.getTimeExpressionType() + ", timeExpression=" + this.getTimeExpression() + ", maxWfInstanceNum=" + this.getMaxWfInstanceNum() + ", enable=" + this.getEnable() + ", notifyUserIds=" + this.getNotifyUserIds() + ", lifeCycle=" + this.getLifeCycle() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ")";
    }
}

